package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 踏勘专家记录表 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_expert")
public class SurveyExpert implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 任务id
     */
    @TableField(value = "task_id")
    private Long taskId;

    /**
     * 踏勘任务id
     */
    @TableField(value = "survey_task_id")
    private Long surveyTaskId;

    /**
     * 踏勘阶段
     */
    @TableField(value = "survey_step")
    private String surveyStep;

    /**
     * 踏勘专家id
     */
    @TableField(value = "expert_user_id")
    private Long expertUserId;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setSurveyTaskId(Long surveyTaskId) {
        this.surveyTaskId = surveyTaskId;
    }

    public Long getSurveyTaskId() {
        return surveyTaskId;
    }

    public void setSurveyStep(String surveyStep) {
        this.surveyStep = surveyStep;
    }

    public String getSurveyStep() {
        return surveyStep;
    }

    public void setExpertUserId(Long expertUserId) {
        this.expertUserId = expertUserId;
    }

    public Long getExpertUserId() {
        return expertUserId;
    }



}