package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 地区表 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "base_region")
public class BaseRegion implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键ID
     */
    @TableId(value = "id")
    private String id;

    /**
     * 区
     */
    @TableField(value = "area")
    private String area;

    /**
     * 市/县
     */
    @TableField(value = "city")
    private String city;

    /**
     * 父级编码
     */
    @TableField(value = "parent_id")
    private String parentId;

    /**
     * 省
     */
    @TableField(value = "province")
    private String province;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 区域级别
     */
    @TableField(value = "level")
    private String level;

    /**
     * 别名
     */
    @TableField(value = "alias")
    private String alias;

    /**
     * 排序
     */
    @TableField(value = "seq")
    private Integer seq;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getArea() {
        return area;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return city;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return parentId;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvince() {
        return province;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return level;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return alias;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public Integer getSeq() {
        return seq;
    }



}