package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 开放问题表 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "base_open_issue")
public class BaseOpenIssue implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id")
    private String id;

    /**
     * 踏勘题目
     */
    @TableField(value = "question")
    private String question;

    /**
     * 结果提示
     */
    @TableField(value = "answer_tip")
    private String answerTip;

    /**
     * 是否固定(是,否)
     */
    @TableField(value = "is_fixed")
    private String isFixed;

    /**
     * 踏勘次数
     */
    @TableField(value = "survey_count")
    private String surveyCount;

    /**
     * 标签1
     */
    @TableField(value = "tag_one")
    private String tagOne;

    /**
     * 标签2
     */
    @TableField(value = "tag_two")
    private String tagTwo;

    /**
     * 标签3
     */
    @TableField(value = "tag_thire")
    private String tagThire;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getQuestion() {
        return question;
    }

    public void setAnswerTip(String answerTip) {
        this.answerTip = answerTip;
    }

    public String getAnswerTip() {
        return answerTip;
    }

    public void setIsFixed(String isFixed) {
        this.isFixed = isFixed;
    }

    public String getIsFixed() {
        return isFixed;
    }

    public void setSurveyCount(String surveyCount) {
        this.surveyCount = surveyCount;
    }

    public String getSurveyCount() {
        return surveyCount;
    }

    public void setTagOne(String tagOne) {
        this.tagOne = tagOne;
    }

    public String getTagOne() {
        return tagOne;
    }

    public void setTagTwo(String tagTwo) {
        this.tagTwo = tagTwo;
    }

    public String getTagTwo() {
        return tagTwo;
    }

    public void setTagThire(String tagThire) {
        this.tagThire = tagThire;
    }

    public String getTagThire() {
        return tagThire;
    }



}