package com.wlos.app.interceptor;

import com.wlos.app.dto.EnvironmentVariableDTO;
import com.wlos.app.utils.RedisUtil;
import com.wlos.app.utils.SecurityUtils;
import com.wlos.app.utils.UserSessionContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * 用户信息系统拦截器
 */
@Component
public class UserSessionInterceptor extends HandlerInterceptorAdapter {
    protected transient final Logger log = LoggerFactory.getLogger(getClass());

    @Autowired
    private RedisUtil redisService;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if(HttpMethod.OPTIONS.matches(request.getMethod())) {
            return true;
        }
        String token = SecurityUtils.getToken();
        log.info("请求路径:{}====token:{}=====", request.getRequestURL(), token);
        UserSessionContext.setToken(token);
        EnvironmentVariableDTO environmentVariableDTO = null;
        if (StringUtils.isNotBlank(token)) {
            environmentVariableDTO = (EnvironmentVariableDTO) redisService.get(token + "_GLOBALVARIABLE");
        }
        UserSessionContext.setEnvironmentVariable(Optional.ofNullable(environmentVariableDTO).orElse(new EnvironmentVariableDTO()));
        return super.preHandle(request, response, handler);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserSessionContext.remove();
    }

}
