package com.wlos.app.enums;

import org.apache.commons.lang3.StringUtils;
import java.util.Objects;

/**
 *
 * 模型数据类型
 * @author fos
 * @since Aug 30, 2024, 5:03:26 PM
 */
public enum ModelDataTypeEnum {

   ;


    private String enName;
    private String identifier;
    private AttributeTypeEnums dataType;
    private String format;
    private String pattern;


    public static ModelDataTypeEnum getDataModelTypeByName(String name) {
        for (ModelDataTypeEnum value : values()) {
            if (StringUtils.equalsIgnoreCase(name, value.name()) || Objects.equals(name, value.getIdentifier())) {
                return value;
            }
        }
        return null;
    }

    public String getEnName() {
        return enName;
    }

    public String getIdentifier() {
        return identifier;
    }

    public AttributeTypeEnums getDataType() {
        return dataType;
    }

    public String getFormat() {
        return format;
    }

    public String getPattern() {
        return pattern;
    }

    ModelDataTypeEnum(String enName, String identifier, AttributeTypeEnums dataType, String format, String pattern) {
        this.enName = enName;
        this.identifier = identifier;
        this.dataType = dataType;
        this.format = format;
        this.pattern = pattern;
    }
    
}
