package com.wlos.app.enums;

/**
 * 字段数据类型
 */
public enum AttributeTypeEnums {
    String(AttributeKindEnums.String,"字符串"),
    Text(AttributeKindEnums.String,"长文本"),
    RichText(AttributeKindEnums.String,"富文本"),
    Integer(AttributeKindEnums.Number,"整数"),
    BigInteger(AttributeKindEnums.Number,"长整数"),
    SmallInteger(AttributeKindEnums.Number,"短整数"),
    TinyInteger(AttributeKindEnums.Number,"极短整数"),
    Float(AttributeKindEnums.Number,"单精度浮点数"),
    Double(AttributeKindEnums.Number,"双精度浮点数"),
    Decimal(AttributeKindEnums.Number,"小数"),
    Date(AttributeKindEnums.Date,"日期"),
    Time(AttributeKindEnums.Date,"时间"),
    DateTime(AttributeKindEnums.Date,"日期时间"),
    Year(AttributeKindEnums.Date,"年"),
    Boolean(AttributeKindEnums.Boolean,"布尔值"),
    Object(AttributeKindEnums.Object,"对象"),
    List(AttributeKindEnums.List,"列表"),
    Binary(AttributeKindEnums.String,"二进制"),
    Url(AttributeKindEnums.String,"Url"),
    Email(AttributeKindEnums.String,"电子邮箱"),
    Telephone(AttributeKindEnums.String,"座机号"),
    Mobile(AttributeKindEnums.String,"手机号"),
    IdNumber(AttributeKindEnums.String,"身份证号"),
    ZipCode(AttributeKindEnums.String,"邮编"),
    Autoinc(AttributeKindEnums.String,"自动编号"),
    Option(AttributeKindEnums.Object,"静态实体"),
    Formula(AttributeKindEnums.String,"公式"),
    Lookup(AttributeKindEnums.NAN,"查找字段"),
    Image(AttributeKindEnums.List,"一组图片"),
    Audio(AttributeKindEnums.List,"一组音频"),
    Video(AttributeKindEnums.List,"一组视频"),
    File(AttributeKindEnums.List,"一组文件"),
    Entity(AttributeKindEnums.Object,"实体"),
    Primarykey(AttributeKindEnums.Object,"主键"),
    Enumeration(AttributeKindEnums.String,"枚举"),

    Uuid(AttributeKindEnums.String, "UUID"),
    SemanticVersion(AttributeKindEnums.String, "语义化版本号"),
    Geometry(AttributeKindEnums.Object, "经纬度"),
    Color(AttributeKindEnums.String, "颜色"),
    Address(AttributeKindEnums.Object, "地址"),
    ;

    private AttributeKindEnums kind;
    private String cnName;

    AttributeTypeEnums(AttributeKindEnums kind, String cnName) {
        this.kind = kind;
        this.cnName = cnName;
    }

    public AttributeKindEnums getKind() {
        return kind;
    }

    public java.lang.String getCnName() {
        return cnName;
    }
}
