package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.VenueInformationMapper;
import com.wlos.app.model.VenueInformation;
import com.wlos.app.da.service.VenueInformationService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.VenueInformationBO; 
import com.wlos.app.vo.VenueInformationVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_WxdwWhereBO;
import com.wlos.app.bo.where.DataQuery_NIUaWhereBO;
import com.wlos.app.bo.where.ModifyvenueinformationdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_HwicWhereBO;
/**
 * 场馆信息 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:35 PM
 * @since v0.1
 */
@Service
public class VenueInformationServiceImpl extends ServiceImpl<VenueInformationMapper, VenueInformation> implements VenueInformationService {



    @Autowired
    private VenueInformationMapper venueInformationMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询场馆信息
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public VenueInformation queryById(String id) {
        LambdaQueryWrapper<VenueInformation> queryByPrimaryKey = Wrappers.<VenueInformation>lambdaQuery()
                .eq(VenueInformation::getId, id);
        return venueInformationMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<VenueInformation> page(Page<VenueInformation> page, VenueInformation condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建场馆信息
     *
     * @param venueInformation 场馆信息载体
     * @return 实例主键
     */
    @Override
    public String insert(VenueInformation venueInformation) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(venueInformation));
        venueInformationMapper.insert(venueInformation);
        return venueInformation.getId();
    }

    /**
     * 更新场馆信息
     *
     * @param id 主键id
     * @param venueInformation 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, VenueInformation venueInformation) {
        return venueInformationMapper.update(venueInformation, Wrappers.<VenueInformation>lambdaUpdate()
                .eq(VenueInformation::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return venueInformationMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return venueInformationMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  场馆信息表 新增操作
     * @param venueInformationBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(VenueInformationBO venueInformationBo) {

        //主键赋值
        String entityId = "";







        VenueInformation venueInformation = BeanUtil.copyProperties(venueInformationBo,VenueInformation.class);
        //执行主表 场馆信息新增
        save(venueInformation);
        return venueInformation.getId();
    }


    




  
    /**
     * 流程-根据场馆id查询场馆信息-数据查询 场馆信息表 数据查询
     *
     * @param dataQuery_WxdwWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public VenueInformation selectOne(DataQuery_WxdwWhereBO dataQuery_WxdwWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_WxdwWhereBo));
        VenueInformation res = venueInformationMapper.dataQuery_Wxdw(dataQuery_WxdwWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据区域查询场馆列表-数据查询 场馆信息表 数据查询
     *
     * @param dataQuery_NIUaWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<VenueInformation> list(DataQuery_NIUaWhereBO dataQuery_NIUaWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_NIUaWhereBo));
        List<VenueInformation> res = venueInformationMapper.dataQuery_NIUa(dataQuery_NIUaWhereBo);


        return res;

    }

    




  
    /**
     * 修改场馆信息-数据修改 场馆信息表 数据修改
     *
     * @param venueInformationBo 修改参数BO 
     * @param modifyvenueinformationdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(VenueInformationBO venueInformationBo,ModifyvenueinformationdataModificationWhereBO modifyvenueinformationdataModificationWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = venueInformationMapper.modifyvenueinformationdataModification(venueInformationBo,modifyvenueinformationdataModificationWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 流程-修改场馆信息-数据查询 场馆信息表 数据查询
     *
     * @param dataQuery_HwicWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public VenueInformation selectOne(DataQuery_HwicWhereBO dataQuery_HwicWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_HwicWhereBo));
        VenueInformation res = venueInformationMapper.dataQuery_Hwic(dataQuery_HwicWhereBo);


        return res;

    }

    
    static final class VenueInformationConstants{


     /***
	 * dataQuery_Wxdw use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_WXDW_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_NIUa use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_NIUA_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};








     /***
	 * dataQuery_Hwic use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_HWIC_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}