package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyUserMapper;
import com.wlos.app.model.SurveyUser;
import com.wlos.app.da.service.SurveyUserService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyUserBO; 
import com.wlos.app.vo.SurveyUserVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_emOBWhereBO;
import com.wlos.app.bo.where.DataQuery_rqVqWhereBO;
import com.wlos.app.bo.where.DataQuery_khZhWhereBO;
import com.wlos.app.bo.where.DataQuery_cHlcWhereBO;
/**
 * 用户表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Service
public class SurveyUserServiceImpl extends ServiceImpl<SurveyUserMapper, SurveyUser> implements SurveyUserService {



    @Autowired
    private SurveyUserMapper surveyUserMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询用户表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyUser queryById(String id) {
        LambdaQueryWrapper<SurveyUser> queryByPrimaryKey = Wrappers.<SurveyUser>lambdaQuery()
                .eq(SurveyUser::getId, id);
        return surveyUserMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyUser> page(Page<SurveyUser> page, SurveyUser condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建用户表
     *
     * @param surveyUser 用户表载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyUser surveyUser) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyUser.setId(entityId);





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyUser));
        surveyUserMapper.insert(surveyUser);
        return surveyUser.getId();
    }

    /**
     * 更新用户表
     *
     * @param id 主键id
     * @param surveyUser 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyUser surveyUser) {
        return surveyUserMapper.update(surveyUser, Wrappers.<SurveyUser>lambdaUpdate()
                .eq(SurveyUser::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyUserMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyUserMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  用户表表 新增操作
     * @param surveyUserBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyUserBO surveyUserBo) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyUserBo.setId(entityId);







        SurveyUser surveyUser = BeanUtil.copyProperties(surveyUserBo,SurveyUser.class);
        //执行主表 用户表新增
        save(surveyUser);
        return surveyUser.getId();
    }


    




  
    /**
     * 流程-查询当前用户信息-数据查询 用户表表 数据查询
     *
     * @param dataQuery_emOBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyUser selectOne(DataQuery_emOBWhereBO dataQuery_emOBWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_emOBWhereBo));
        SurveyUser res = surveyUserMapper.dataQuery_emOB(dataQuery_emOBWhereBo);


        return res;

    }

    




  
    /**
     * 流程-查询用户-数据查询 用户表表 数据查询
     *
     * @param dataQuery_rqVqWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyUser> list(DataQuery_rqVqWhereBO dataQuery_rqVqWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_rqVqWhereBo));
        List<SurveyUser> res = surveyUserMapper.dataQuery_rqVq(dataQuery_rqVqWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据机构Id和类型查询用户列表-数据查询 用户表表 数据查询
     *
     * @param dataQuery_khZhWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyUser> list(DataQuery_khZhWhereBO dataQuery_khZhWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_khZhWhereBo));
        List<SurveyUser> res = surveyUserMapper.dataQuery_khZh(dataQuery_khZhWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据bcxToken获取用户信息-数据查询 用户表表 数据查询
     *
     * @param dataQuery_cHlcWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyUser selectOne(DataQuery_cHlcWhereBO dataQuery_cHlcWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_cHlcWhereBo));
        SurveyUser res = surveyUserMapper.dataQuery_cHlc(dataQuery_cHlcWhereBo);


        return res;

    }

    
    static final class SurveyUserConstants{


     /***
	 * dataQuery_emOB use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_EMOB_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_rqVq use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_RQVQ_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_khZh use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_KHZH_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_cHlc use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_CHLC_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}