package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyTaskMapper;
import com.wlos.app.model.SurveyTask;
import com.wlos.app.da.service.SurveyTaskService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyTaskBO; 
import com.wlos.app.vo.SurveyTaskVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.ModifytskstsdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_dykBWhereBO;
import com.wlos.app.bo.where.DataQuery_EQShWhereBO;
import com.wlos.app.bo.where.DataQueryWhereBO;
import com.wlos.app.bo.DataQueryBO;
import com.wlos.app.bo.where.DataQuery_JvFIWhereBO;
import com.wlos.app.bo.DataqueryJvfiBO;
/**
 * 任务信息 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:34 PM
 * @since v0.1
 */
@Service
public class SurveyTaskServiceImpl extends ServiceImpl<SurveyTaskMapper, SurveyTask> implements SurveyTaskService {



    @Autowired
    private SurveyTaskMapper surveyTaskMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询任务信息
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyTask queryById(String id) {
        LambdaQueryWrapper<SurveyTask> queryByPrimaryKey = Wrappers.<SurveyTask>lambdaQuery()
                .eq(SurveyTask::getId, id);
        return surveyTaskMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyTask> page(Page<SurveyTask> page, SurveyTask condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建任务信息
     *
     * @param surveyTask 任务信息载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyTask surveyTask) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyTask.setId(entityId);





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyTask));
        surveyTaskMapper.insert(surveyTask);
        return surveyTask.getId();
    }

    /**
     * 更新任务信息
     *
     * @param id 主键id
     * @param surveyTask 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyTask surveyTask) {
        return surveyTaskMapper.update(surveyTask, Wrappers.<SurveyTask>lambdaUpdate()
                .eq(SurveyTask::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyTaskMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyTaskMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  任务信息表 新增操作
     * @param surveyTaskBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyTaskBO surveyTaskBo) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyTaskBo.setId(entityId);







        SurveyTask surveyTask = BeanUtil.copyProperties(surveyTaskBo,SurveyTask.class);
        //执行主表 任务信息新增
        save(surveyTask);
        return surveyTask.getId();
    }


    




  
    /**
     * 修改任务状态-数据修改 任务信息表 数据修改
     *
     * @param surveyTaskBo 修改参数BO 
     * @param modifytskstsdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyTaskBO surveyTaskBo,ModifytskstsdataModificationWhereBO modifytskstsdataModificationWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyTaskMapper.modifytskstsdataModification(surveyTaskBo,modifytskstsdataModificationWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 流程-查询任务详情-数据查询 任务信息表 数据查询
     *
     * @param dataQuery_dykBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyTask selectOne(DataQuery_dykBWhereBO dataQuery_dykBWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_dykBWhereBo));
        SurveyTask res = surveyTaskMapper.dataQuery_dykB(dataQuery_dykBWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据用户id查询进行中的任务列-数据查询 任务信息表 数据查询
     *
     * @param dataQuery_EQShWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyTask> list(DataQuery_EQShWhereBO dataQuery_EQShWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_EQShWhereBo));
        List<SurveyTask> res = surveyTaskMapper.dataQuery_EQSh(dataQuery_EQShWhereBo);


        return res;

    }

    




  
    /**
     * 流程-模糊搜索任务-数据查询 任务信息表 数据查询
     *
     * @param dataQueryWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public Page<DataQueryBO> page(DataQueryWhereBO dataQueryWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQueryWhereBo));
        Page<DataQueryBO> res = surveyTaskMapper.dataQuery(new Page<>(dataQueryWhereBo.getCurrent(),dataQueryWhereBo.getSize())
            ,dataQueryWhereBo);



        return res;

    }

    




  
    /**
     * 流程-不含未接受的任务列表-数据查询 任务信息表 数据查询
     *
     * @param dataQuery_JvFIWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public Page<DataqueryJvfiBO> page(DataQuery_JvFIWhereBO dataQuery_JvFIWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_JvFIWhereBo));
        Page<DataqueryJvfiBO> res = surveyTaskMapper.dataQuery_JvFI(new Page<>(dataQuery_JvFIWhereBo.getCurrent(),dataQuery_JvFIWhereBo.getSize())
            ,dataQuery_JvFIWhereBo);



        return res;

    }

    
    static final class SurveyTaskConstants{






     /***
	 * dataQuery_dykB use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_DYKB_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_EQSh use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_EQSH_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_JvFI use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_JVFI_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}