package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyReformMapper;
import com.wlos.app.model.SurveyReform;
import com.wlos.app.da.service.SurveyReformService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyReformBO; 
import com.wlos.app.vo.SurveyReformVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO;
/**
 * 回复整改记录表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
@Service
public class SurveyReformServiceImpl extends ServiceImpl<SurveyReformMapper, SurveyReform> implements SurveyReformService {



    @Autowired
    private SurveyReformMapper surveyReformMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询回复整改记录表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyReform queryById(String id) {
        LambdaQueryWrapper<SurveyReform> queryByPrimaryKey = Wrappers.<SurveyReform>lambdaQuery()
                .eq(SurveyReform::getId, id);
        return surveyReformMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyReform> page(Page<SurveyReform> page, SurveyReform condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建回复整改记录表
     *
     * @param surveyReform 回复整改记录表载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyReform surveyReform) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyReform));
        surveyReformMapper.insert(surveyReform);
        return surveyReform.getId();
    }

    /**
     * 更新回复整改记录表
     *
     * @param id 主键id
     * @param surveyReform 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyReform surveyReform) {
        return surveyReformMapper.update(surveyReform, Wrappers.<SurveyReform>lambdaUpdate()
                .eq(SurveyReform::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyReformMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyReformMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  回复整改记录表表 新增操作
     * @param surveyReformBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyReformBO surveyReformBo) {

        //主键赋值
        String entityId = "";







        SurveyReform surveyReform = BeanUtil.copyProperties(surveyReformBo,SurveyReform.class);
        //执行主表 回复整改记录表新增
        save(surveyReform);
        return surveyReform.getId();
    }


    




  
    /**
     * 根据问卷问题id删除对应记录-数据删除-整改表 回复整改记录表表 数据删除
     *
     * @param delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBo 删除参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer delete(DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBo) {
        return  surveyReformMapper.delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTbl(delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBo);
    } 

    
    static final class SurveyReformConstants{




}
}