package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyQuestionnaireMapper;
import com.wlos.app.model.SurveyQuestionnaire;
import com.wlos.app.da.service.SurveyQuestionnaireService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyQuestionnaireBO; 
import com.wlos.app.vo.SurveyQuestionnaireVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.ModifyplandataModificationQuestionnaireWhereBO;
import com.wlos.app.bo.where.GenquestionnairedataModificationQuestionnaireStsWhereBO;
import com.wlos.app.bo.where.DataQuery_dqCrWhereBO;
import com.wlos.app.bo.where.DataQuery_iKAYWhereBO;
import com.wlos.app.bo.where.DataQuery_yeFLWhereBO;
import com.wlos.app.bo.where.UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO;
/**
 * 问卷 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Service
public class SurveyQuestionnaireServiceImpl extends ServiceImpl<SurveyQuestionnaireMapper, SurveyQuestionnaire> implements SurveyQuestionnaireService {



    @Autowired
    private SurveyQuestionnaireMapper surveyQuestionnaireMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询问卷
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyQuestionnaire queryById(String id) {
        LambdaQueryWrapper<SurveyQuestionnaire> queryByPrimaryKey = Wrappers.<SurveyQuestionnaire>lambdaQuery()
                .eq(SurveyQuestionnaire::getId, id);
        return surveyQuestionnaireMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyQuestionnaire> page(Page<SurveyQuestionnaire> page, SurveyQuestionnaire condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建问卷
     *
     * @param surveyQuestionnaire 问卷载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyQuestionnaire surveyQuestionnaire) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyQuestionnaire));
        surveyQuestionnaireMapper.insert(surveyQuestionnaire);
        return surveyQuestionnaire.getId();
    }

    /**
     * 更新问卷
     *
     * @param id 主键id
     * @param surveyQuestionnaire 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyQuestionnaire surveyQuestionnaire) {
        return surveyQuestionnaireMapper.update(surveyQuestionnaire, Wrappers.<SurveyQuestionnaire>lambdaUpdate()
                .eq(SurveyQuestionnaire::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyQuestionnaireMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyQuestionnaireMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  问卷表 新增操作
     * @param surveyQuestionnaireBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyQuestionnaireBO surveyQuestionnaireBo) {

        //主键赋值
        String entityId = "";







        SurveyQuestionnaire surveyQuestionnaire = BeanUtil.copyProperties(surveyQuestionnaireBo,SurveyQuestionnaire.class);
        //执行主表 问卷新增
        save(surveyQuestionnaire);
        return surveyQuestionnaire.getId();
    }


    




  
    /**
     * 修改计划-数据修改-问卷 问卷表 数据修改
     *
     * @param surveyQuestionnaireBo 修改参数BO 
     * @param modifyplandataModificationQuestionnaireWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyQuestionnaireBO surveyQuestionnaireBo,ModifyplandataModificationQuestionnaireWhereBO modifyplandataModificationQuestionnaireWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyQuestionnaireMapper.modifyplandataModificationQuestionnaire(surveyQuestionnaireBo,modifyplandataModificationQuestionnaireWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 生成问卷-数据修改-问卷状态 问卷表 数据修改
     *
     * @param surveyQuestionnaireBo 修改参数BO 
     * @param genquestionnairedataModificationQuestionnaireStsWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyQuestionnaireBO surveyQuestionnaireBo,GenquestionnairedataModificationQuestionnaireStsWhereBO genquestionnairedataModificationQuestionnaireStsWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyQuestionnaireMapper.genquestionnairedataModificationQuestionnaireSts(surveyQuestionnaireBo,genquestionnairedataModificationQuestionnaireStsWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 流程-生成问卷-数据查询-问卷信息 问卷表 数据查询
     *
     * @param dataQuery_dqCrWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyQuestionnaire selectOne(DataQuery_dqCrWhereBO dataQuery_dqCrWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_dqCrWhereBo));
        SurveyQuestionnaire res = surveyQuestionnaireMapper.dataQuery_dqCr(dataQuery_dqCrWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据计划id和问题类型查询问题列表-数据查询-问卷 问卷表 数据查询
     *
     * @param dataQuery_iKAYWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyQuestionnaire selectOne(DataQuery_iKAYWhereBO dataQuery_iKAYWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_iKAYWhereBo));
        SurveyQuestionnaire res = surveyQuestionnaireMapper.dataQuery_iKAY(dataQuery_iKAYWhereBo);


        return res;

    }

    




  
    /**
     * 流程-新增问卷补充问题记录-数据查询-获取问卷信息 问卷表 数据查询
     *
     * @param dataQuery_yeFLWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyQuestionnaire selectOne(DataQuery_yeFLWhereBO dataQuery_yeFLWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_yeFLWhereBo));
        SurveyQuestionnaire res = surveyQuestionnaireMapper.dataQuery_yeFL(dataQuery_yeFLWhereBo);


        return res;

    }

    




  
    /**
     * 更新踏勘结果-报告生成未开发-数据修改-问卷状态更新 问卷表 数据修改
     *
     * @param surveyQuestionnaireBo 修改参数BO 
     * @param updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyQuestionnaireBO surveyQuestionnaireBo,UpdsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBO updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyQuestionnaireMapper.updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpd(surveyQuestionnaireBo,updsurveyresultsreportgenerationundevelopeddataModificationQuestionnaireStsUpdWhereBo);
        return effectLines;      
    }   


    
    static final class SurveyQuestionnaireConstants{










     /***
	 * dataQuery_dqCr use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_DQCR_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_iKAY use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_IKAY_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_yeFL use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_YEFL_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};






}
}