package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyProjectTempMapper;
import com.wlos.app.model.SurveyProjectTemp;
import com.wlos.app.da.service.SurveyProjectTempService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyProjectTempBO; 
import com.wlos.app.vo.SurveyProjectTempVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DelproblemrecordbasedontmpproblemiddataDeletionWhereBO;
import com.wlos.app.bo.where.TmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_TmSjWhereBO;
import com.wlos.app.bo.where.DataQuery_fHTNWhereBO;
import com.wlos.app.bo.where.DataQuery_YsMUWhereBO;
/**
 * 问卷题目暂存表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
@Service
public class SurveyProjectTempServiceImpl extends ServiceImpl<SurveyProjectTempMapper, SurveyProjectTemp> implements SurveyProjectTempService {



    @Autowired
    private SurveyProjectTempMapper surveyProjectTempMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询问卷题目暂存表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyProjectTemp queryById(String id) {
        LambdaQueryWrapper<SurveyProjectTemp> queryByPrimaryKey = Wrappers.<SurveyProjectTemp>lambdaQuery()
                .eq(SurveyProjectTemp::getId, id);
        return surveyProjectTempMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyProjectTemp> page(Page<SurveyProjectTemp> page, SurveyProjectTemp condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建问卷题目暂存表
     *
     * @param surveyProjectTemp 问卷题目暂存表载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyProjectTemp surveyProjectTemp) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyProjectTemp));
        surveyProjectTempMapper.insert(surveyProjectTemp);
        return surveyProjectTemp.getId();
    }

    /**
     * 更新问卷题目暂存表
     *
     * @param id 主键id
     * @param surveyProjectTemp 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyProjectTemp surveyProjectTemp) {
        return surveyProjectTempMapper.update(surveyProjectTemp, Wrappers.<SurveyProjectTemp>lambdaUpdate()
                .eq(SurveyProjectTemp::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyProjectTempMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyProjectTempMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  问卷题目暂存表表 新增操作
     * @param surveyProjectTempBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyProjectTempBO surveyProjectTempBo) {

        //主键赋值
        String entityId = "";







        SurveyProjectTemp surveyProjectTemp = BeanUtil.copyProperties(surveyProjectTempBo,SurveyProjectTemp.class);
        //执行主表 问卷题目暂存表新增
        save(surveyProjectTemp);
        return surveyProjectTemp.getId();
    }


    




  
    /**
     * 根据暂存问题id删除问题记录-数据删除 问卷题目暂存表表 数据删除
     *
     * @param delproblemrecordbasedontmpproblemiddataDeletionWhereBo 删除参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer delete(DelproblemrecordbasedontmpproblemiddataDeletionWhereBO delproblemrecordbasedontmpproblemiddataDeletionWhereBo) {
        return  surveyProjectTempMapper.delproblemrecordbasedontmpproblemiddataDeletion(delproblemrecordbasedontmpproblemiddataDeletionWhereBo);
    } 

    




  
    /**
     * 新增补充问题暂存-数据修改 问卷题目暂存表表 数据修改
     *
     * @param surveyProjectTempBo 修改参数BO 
     * @param tmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public Integer update(SurveyProjectTempBO surveyProjectTempBo,TmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBO tmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBo) {

        Integer effectLines=0;
        //主表修改    
        effectLines = surveyProjectTempMapper.tmpstgofnewlyaddedsupplementaryquestionsdataModification(surveyProjectTempBo,tmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBo);
        return effectLines;      
    }   


    




  
    /**
     * 流程-根据问卷id查询暂存问题-数据查询 问卷题目暂存表表 数据查询
     *
     * @param dataQuery_TmSjWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyProjectTemp> list(DataQuery_TmSjWhereBO dataQuery_TmSjWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_TmSjWhereBo));
        List<SurveyProjectTemp> res = surveyProjectTempMapper.dataQuery_TmSj(dataQuery_TmSjWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据类型和问卷id查询暂存问题-数据查询 问卷题目暂存表表 数据查询
     *
     * @param dataQuery_fHTNWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyProjectTemp> list(DataQuery_fHTNWhereBO dataQuery_fHTNWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_fHTNWhereBo));
        List<SurveyProjectTemp> res = surveyProjectTempMapper.dataQuery_fHTN(dataQuery_fHTNWhereBo);


        return res;

    }

    




  
    /**
     * 流程-生成问卷-数据查询-问卷暂存问题 问卷题目暂存表表 数据查询
     *
     * @param dataQuery_YsMUWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<SurveyProjectTemp> list(DataQuery_YsMUWhereBO dataQuery_YsMUWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_YsMUWhereBo));
        List<SurveyProjectTemp> res = surveyProjectTempMapper.dataQuery_YsMU(dataQuery_YsMUWhereBo);


        return res;

    }

    
    static final class SurveyProjectTempConstants{










     /***
	 * dataQuery_TmSj use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_TMSJ_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_fHTN use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_FHTN_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_YsMU use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_YSMU_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}