package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyExpertMapper;
import com.wlos.app.model.SurveyExpert;
import com.wlos.app.da.service.SurveyExpertService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyExpertBO; 
import com.wlos.app.vo.SurveyExpertVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_KThGWhereBO;
/**
 * 踏勘专家记录表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class SurveyExpertServiceImpl extends ServiceImpl<SurveyExpertMapper, SurveyExpert> implements SurveyExpertService {



    @Autowired
    private SurveyExpertMapper surveyExpertMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询踏勘专家记录表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyExpert queryById(String id) {
        LambdaQueryWrapper<SurveyExpert> queryByPrimaryKey = Wrappers.<SurveyExpert>lambdaQuery()
                .eq(SurveyExpert::getId, id);
        return surveyExpertMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyExpert> page(Page<SurveyExpert> page, SurveyExpert condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建踏勘专家记录表
     *
     * @param surveyExpert 踏勘专家记录表载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyExpert surveyExpert) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyExpert));
        surveyExpertMapper.insert(surveyExpert);
        return surveyExpert.getId();
    }

    /**
     * 更新踏勘专家记录表
     *
     * @param id 主键id
     * @param surveyExpert 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyExpert surveyExpert) {
        return surveyExpertMapper.update(surveyExpert, Wrappers.<SurveyExpert>lambdaUpdate()
                .eq(SurveyExpert::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyExpertMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyExpertMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  踏勘专家记录表表 新增操作
     * @param surveyExpertBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyExpertBO surveyExpertBo) {

        //主键赋值
        String entityId = "";







        SurveyExpert surveyExpert = BeanUtil.copyProperties(surveyExpertBo,SurveyExpert.class);
        //执行主表 踏勘专家记录表新增
        save(surveyExpert);
        return surveyExpert.getId();
    }


    




  
    /**
     * 流程-计划绑定专家-数据查询-踏勘专家记录 踏勘专家记录表表 数据查询
     *
     * @param dataQuery_KThGWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public SurveyExpert selectOne(DataQuery_KThGWhereBO dataQuery_KThGWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_KThGWhereBo));
        SurveyExpert res = surveyExpertMapper.dataQuery_KThG(dataQuery_KThGWhereBo);


        return res;

    }

    
    static final class SurveyExpertConstants{


     /***
	 * dataQuery_KThG use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_KTHG_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}