package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.SurveyAssistMapper;
import com.wlos.app.model.SurveyAssist;
import com.wlos.app.da.service.SurveyAssistService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.SurveyAssistBO; 
import com.wlos.app.vo.SurveyAssistVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_ZzJMWhereBO;
import com.wlos.app.bo.DataqueryZzjmBO;
/**
 * 勘查协助 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Service
public class SurveyAssistServiceImpl extends ServiceImpl<SurveyAssistMapper, SurveyAssist> implements SurveyAssistService {



    @Autowired
    private SurveyAssistMapper surveyAssistMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询勘查协助
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public SurveyAssist queryById(String id) {
        LambdaQueryWrapper<SurveyAssist> queryByPrimaryKey = Wrappers.<SurveyAssist>lambdaQuery()
                .eq(SurveyAssist::getId, id);
        return surveyAssistMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<SurveyAssist> page(Page<SurveyAssist> page, SurveyAssist condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建勘查协助
     *
     * @param surveyAssist 勘查协助载体
     * @return 实例主键
     */
    @Override
    public String insert(SurveyAssist surveyAssist) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyAssist.setId(entityId);





        log.info("starting insert params:{}",JSONObject.toJSONString(surveyAssist));
        surveyAssistMapper.insert(surveyAssist);
        return surveyAssist.getId();
    }

    /**
     * 更新勘查协助
     *
     * @param id 主键id
     * @param surveyAssist 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, SurveyAssist surveyAssist) {
        return surveyAssistMapper.update(surveyAssist, Wrappers.<SurveyAssist>lambdaUpdate()
                .eq(SurveyAssist::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return surveyAssistMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return surveyAssistMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  勘查协助表 新增操作
     * @param surveyAssistBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(SurveyAssistBO surveyAssistBo) {

        //主键赋值
        String entityId = IdUtil.objectId();
        surveyAssistBo.setId(entityId);







        SurveyAssist surveyAssist = BeanUtil.copyProperties(surveyAssistBo,SurveyAssist.class);
        //执行主表 勘查协助新增
        save(surveyAssist);
        return surveyAssist.getId();
    }


    




  
    /**
     * 流程-根据任务和阶段查询审批通过的专家-数据查询 勘查协助表 数据查询
     *
     * @param dataQuery_ZzJMWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public DataqueryZzjmBO selectOne(DataQuery_ZzJMWhereBO dataQuery_ZzJMWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_ZzJMWhereBo));
        DataqueryZzjmBO res = surveyAssistMapper.dataQuery_ZzJM(dataQuery_ZzJMWhereBo);


        return res;

    }

    
    static final class SurveyAssistConstants{


     /***
	 * dataQuery_ZzJM use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_ZZJM_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}