package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.BaseRegionMapper;
import com.wlos.app.model.BaseRegion;
import com.wlos.app.da.service.BaseRegionService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.BaseRegionBO; 
import com.wlos.app.vo.BaseRegionVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_YQXFWhereBO;
import com.wlos.app.bo.where.DataQuery_EUQOWhereBO;
import com.wlos.app.bo.where.DataQuery_gdkBWhereBO;
/**
 * 地区表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Service
public class BaseRegionServiceImpl extends ServiceImpl<BaseRegionMapper, BaseRegion> implements BaseRegionService {



    @Autowired
    private BaseRegionMapper baseRegionMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询地区表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public BaseRegion queryById(String id) {
        LambdaQueryWrapper<BaseRegion> queryByPrimaryKey = Wrappers.<BaseRegion>lambdaQuery()
                .eq(BaseRegion::getId, id);
        return baseRegionMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<BaseRegion> page(Page<BaseRegion> page, BaseRegion condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建地区表
     *
     * @param baseRegion 地区表载体
     * @return 实例主键
     */
    @Override
    public String insert(BaseRegion baseRegion) {

        //主键赋值
        String entityId = IdUtil.objectId();
        baseRegion.setId(entityId);





        log.info("starting insert params:{}",JSONObject.toJSONString(baseRegion));
        baseRegionMapper.insert(baseRegion);
        return baseRegion.getId();
    }

    /**
     * 更新地区表
     *
     * @param id 主键id
     * @param baseRegion 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, BaseRegion baseRegion) {
        return baseRegionMapper.update(baseRegion, Wrappers.<BaseRegion>lambdaUpdate()
                .eq(BaseRegion::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return baseRegionMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return baseRegionMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  地区表表 新增操作
     * @param baseRegionBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(BaseRegionBO baseRegionBo) {

        //主键赋值
        String entityId = IdUtil.objectId();
        baseRegionBo.setId(entityId);







        BaseRegion baseRegion = BeanUtil.copyProperties(baseRegionBo,BaseRegion.class);
        //执行主表 地区表新增
        save(baseRegion);
        return baseRegion.getId();
    }


    




  
    /**
     * 流程-根据上级编码和级别编号查询市级列表-数据查询 地区表表 数据查询
     *
     * @param dataQuery_YQXFWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseRegion> list(DataQuery_YQXFWhereBO dataQuery_YQXFWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_YQXFWhereBo));
        List<BaseRegion> res = baseRegionMapper.dataQuery_YQXF(dataQuery_YQXFWhereBo);


        return res;

    }

    




  
    /**
     * 流程-查询省级列表-数据查询 地区表表 数据查询
     *
     * @param dataQuery_EUQOWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseRegion> list(DataQuery_EUQOWhereBO dataQuery_EUQOWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_EUQOWhereBo));
        List<BaseRegion> res = baseRegionMapper.dataQuery_EUQO(dataQuery_EUQOWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据id获取区域信息-数据查询-区域 地区表表 数据查询
     *
     * @param dataQuery_gdkBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public BaseRegion selectOne(DataQuery_gdkBWhereBO dataQuery_gdkBWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_gdkBWhereBo));
        BaseRegion res = baseRegionMapper.dataQuery_gdkB(dataQuery_gdkBWhereBo);


        return res;

    }

    
    static final class BaseRegionConstants{


     /***
	 * dataQuery_YQXF use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_YQXF_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_EUQO use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_EUQO_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_gdkB use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_GDKB_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}