package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.BaseOpenIssueMapper;
import com.wlos.app.model.BaseOpenIssue;
import com.wlos.app.da.service.BaseOpenIssueService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.BaseOpenIssueBO; 
import com.wlos.app.vo.BaseOpenIssueVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_vikAWhereBO;
import com.wlos.app.bo.where.DataQuery_hYiGWhereBO;
/**
 * 开放问题表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class BaseOpenIssueServiceImpl extends ServiceImpl<BaseOpenIssueMapper, BaseOpenIssue> implements BaseOpenIssueService {



    @Autowired
    private BaseOpenIssueMapper baseOpenIssueMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询开放问题表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public BaseOpenIssue queryById(String id) {
        LambdaQueryWrapper<BaseOpenIssue> queryByPrimaryKey = Wrappers.<BaseOpenIssue>lambdaQuery()
                .eq(BaseOpenIssue::getId, id);
        return baseOpenIssueMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<BaseOpenIssue> page(Page<BaseOpenIssue> page, BaseOpenIssue condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建开放问题表
     *
     * @param baseOpenIssue 开放问题表载体
     * @return 实例主键
     */
    @Override
    public String insert(BaseOpenIssue baseOpenIssue) {

        //主键赋值
        String entityId = IdUtil.objectId();
        baseOpenIssue.setId(entityId);





        log.info("starting insert params:{}",JSONObject.toJSONString(baseOpenIssue));
        baseOpenIssueMapper.insert(baseOpenIssue);
        return baseOpenIssue.getId();
    }

    /**
     * 更新开放问题表
     *
     * @param id 主键id
     * @param baseOpenIssue 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, BaseOpenIssue baseOpenIssue) {
        return baseOpenIssueMapper.update(baseOpenIssue, Wrappers.<BaseOpenIssue>lambdaUpdate()
                .eq(BaseOpenIssue::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return baseOpenIssueMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return baseOpenIssueMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  开放问题表表 新增操作
     * @param baseOpenIssueBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(BaseOpenIssueBO baseOpenIssueBo) {

        //主键赋值
        String entityId = IdUtil.objectId();
        baseOpenIssueBo.setId(entityId);







        BaseOpenIssue baseOpenIssue = BeanUtil.copyProperties(baseOpenIssueBo,BaseOpenIssue.class);
        //执行主表 开放问题表新增
        save(baseOpenIssue);
        return baseOpenIssue.getId();
    }


    




  
    /**
     * 流程-暂存固定和开放问题-数据查询开发 开放问题表表 数据查询
     *
     * @param dataQuery_vikAWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseOpenIssue> list(DataQuery_vikAWhereBO dataQuery_vikAWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_vikAWhereBo));
        List<BaseOpenIssue> res = baseOpenIssueMapper.dataQuery_vikA(dataQuery_vikAWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据层级和名称查询开放问题列表-数据查询 开放问题表表 数据查询
     *
     * @param dataQuery_hYiGWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseOpenIssue> list(DataQuery_hYiGWhereBO dataQuery_hYiGWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_hYiGWhereBo));
        List<BaseOpenIssue> res = baseOpenIssueMapper.dataQuery_hYiG(dataQuery_hYiGWhereBo);


        return res;

    }

    
    static final class BaseOpenIssueConstants{


     /***
	 * dataQuery_vikA use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_VIKA_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_hYiG use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_HYIG_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}