package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.BaseFixedIssueMapper;
import com.wlos.app.model.BaseFixedIssue;
import com.wlos.app.da.service.BaseFixedIssueService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.BaseFixedIssueBO; 
import com.wlos.app.vo.BaseFixedIssueVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_ltrJWhereBO;
import com.wlos.app.bo.where.DataQuery_lINFWhereBO;
import com.wlos.app.bo.where.DataQuery_FuxVWhereBO;
import com.wlos.app.bo.where.DataQuery_dvJRWhereBO;
/**
 * 固定问题表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Service
public class BaseFixedIssueServiceImpl extends ServiceImpl<BaseFixedIssueMapper, BaseFixedIssue> implements BaseFixedIssueService {



    @Autowired
    private BaseFixedIssueMapper baseFixedIssueMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询固定问题表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public BaseFixedIssue queryById(String id) {
        LambdaQueryWrapper<BaseFixedIssue> queryByPrimaryKey = Wrappers.<BaseFixedIssue>lambdaQuery()
                .eq(BaseFixedIssue::getId, id);
        return baseFixedIssueMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<BaseFixedIssue> page(Page<BaseFixedIssue> page, BaseFixedIssue condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建固定问题表
     *
     * @param baseFixedIssue 固定问题表载体
     * @return 实例主键
     */
    @Override
    public String insert(BaseFixedIssue baseFixedIssue) {

        //主键赋值
        String entityId = IdUtil.objectId();
        baseFixedIssue.setId(entityId);





        log.info("starting insert params:{}",JSONObject.toJSONString(baseFixedIssue));
        baseFixedIssueMapper.insert(baseFixedIssue);
        return baseFixedIssue.getId();
    }

    /**
     * 更新固定问题表
     *
     * @param id 主键id
     * @param baseFixedIssue 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, BaseFixedIssue baseFixedIssue) {
        return baseFixedIssueMapper.update(baseFixedIssue, Wrappers.<BaseFixedIssue>lambdaUpdate()
                .eq(BaseFixedIssue::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return baseFixedIssueMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return baseFixedIssueMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  固定问题表表 新增操作
     * @param baseFixedIssueBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(BaseFixedIssueBO baseFixedIssueBo) {

        //主键赋值
        String entityId = IdUtil.objectId();
        baseFixedIssueBo.setId(entityId);







        BaseFixedIssue baseFixedIssue = BeanUtil.copyProperties(baseFixedIssueBo,BaseFixedIssue.class);
        //执行主表 固定问题表新增
        save(baseFixedIssue);
        return baseFixedIssue.getId();
    }


    




  
    /**
     * 流程-暂存固定和开放问题-数据查询固定问题 固定问题表表 数据查询
     *
     * @param dataQuery_ltrJWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseFixedIssue> list(DataQuery_ltrJWhereBO dataQuery_ltrJWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_ltrJWhereBo));
        List<BaseFixedIssue> res = baseFixedIssueMapper.dataQuery_ltrJ(dataQuery_ltrJWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据阶段查询固定问题列表-通用问题查询 固定问题表表 数据查询
     *
     * @param dataQuery_lINFWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseFixedIssue> list(DataQuery_lINFWhereBO dataQuery_lINFWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_lINFWhereBo));
        List<BaseFixedIssue> res = baseFixedIssueMapper.dataQuery_lINF(dataQuery_lINFWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据阶段查询固定问题列表-根据场地及活动类型查询 固定问题表表 数据查询
     *
     * @param dataQuery_FuxVWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseFixedIssue> list(DataQuery_FuxVWhereBO dataQuery_FuxVWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_FuxVWhereBo));
        List<BaseFixedIssue> res = baseFixedIssueMapper.dataQuery_FuxV(dataQuery_FuxVWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据阶段查询问题数量-数据查询 固定问题表表 数据查询
     *
     * @param dataQuery_dvJRWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public Page<BaseFixedIssue> page(DataQuery_dvJRWhereBO dataQuery_dvJRWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_dvJRWhereBo));
        Page<BaseFixedIssue> res = baseFixedIssueMapper.dataQuery_dvJR(new Page<>(dataQuery_dvJRWhereBo.getCurrent(),dataQuery_dvJRWhereBo.getSize())
            ,dataQuery_dvJRWhereBo);



        return res;

    }

    
    static final class BaseFixedIssueConstants{


     /***
	 * dataQuery_ltrJ use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_LTRJ_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_lINF use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_LINF_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_FuxV use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_FUXV_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_dvJR use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_DVJR_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}