package com.wlos.app.da.service.impl;


import com.wlos.app.da.mapper.BaseDictMapper;
import com.wlos.app.model.BaseDict;
import com.wlos.app.da.service.BaseDictService;
import com.wlos.app.bl.AnalysisDataService;

import com.wlos.app.da.service.AutoincFieldService;
import com.wlos.app.enums.ModelAttributeEnum;
import com.wlos.app.utils.*;
import com.wlos.app.bo.BaseDictBO; 
import com.wlos.app.vo.BaseDictVO; 
import com.alibaba.fastjson.JSONObject;
import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.TypeReference;



import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import cn.hutool.core.util.IdUtil;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;


import com.wlos.app.bo.where.DataQuery_nTODWhereBO;
import com.wlos.app.bo.where.DataQuery_AbzcWhereBO;
/**
 * 编码表 服务实现类
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:24 PM
 * @since v0.1
 */
@Service
public class BaseDictServiceImpl extends ServiceImpl<BaseDictMapper, BaseDict> implements BaseDictService {



    @Autowired
    private BaseDictMapper baseDictMapper;
    @Autowired
    private AnalysisDataService analysisDataService;
    @Autowired
    private AutoincFieldService autoincFieldService;


    
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 根据id查询编码表
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public BaseDict queryById(String id) {
        LambdaQueryWrapper<BaseDict> queryByPrimaryKey = Wrappers.<BaseDict>lambdaQuery()
                .eq(BaseDict::getId, id);
        return baseDictMapper.selectOne(queryByPrimaryKey);
    }
  
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    @Override
    public Page<BaseDict> page(Page<BaseDict> page, BaseDict condition) {
        return page(page, new QueryWrapper<>(condition));
    }

    /**
     * 创建编码表
     *
     * @param baseDict 编码表载体
     * @return 实例主键
     */
    @Override
    public String insert(BaseDict baseDict) {

        //主键赋值
        String entityId = "";





        log.info("starting insert params:{}",JSONObject.toJSONString(baseDict));
        baseDictMapper.insert(baseDict);
        return baseDict.getId();
    }

    /**
     * 更新编码表
     *
     * @param id 主键id
     * @param baseDict 实例对象
     * @return 影响行数
     */
    @Override
    public Integer update(String id, BaseDict baseDict) {
        return baseDictMapper.update(baseDict, Wrappers.<BaseDict>lambdaUpdate()
                .eq(BaseDict::getId, id));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public Integer deleteById(String id) {
        return baseDictMapper.deleteById(id);
    }
    
    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    @Override
    public int deleteByIds(List<String> list){
        return baseDictMapper.deleteBatchIds(list);
    }    




  
    /**
     * 
     * 通用新增  编码表表 新增操作
     * @param baseDictBo 新增参数 
     * @return 新增id
     */
    @Override
    @Transactional(rollbackFor = {Exception.class,BusinessException.class})
    public String insert(BaseDictBO baseDictBo) {

        //主键赋值
        String entityId = "";







        BaseDict baseDict = BeanUtil.copyProperties(baseDictBo,BaseDict.class);
        //执行主表 编码表新增
        save(baseDict);
        return baseDict.getId();
    }


    




  
    /**
     * 流程-查询编码列表-数据查询 编码表表 数据查询
     *
     * @param dataQuery_nTODWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public List<BaseDict> list(DataQuery_nTODWhereBO dataQuery_nTODWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_nTODWhereBo));
        List<BaseDict> res = baseDictMapper.dataQuery_nTOD(dataQuery_nTODWhereBo);


        return res;

    }

    




  
    /**
     * 流程-根据类型和编码值查询字典名称-数据查询 编码表表 数据查询
     *
     * @param dataQuery_AbzcWhereBo 查询参数BO 
     * @return 查询结果集
     */
    @Override
    public BaseDict selectOne(DataQuery_AbzcWhereBO dataQuery_AbzcWhereBo) {
        log.info("starting query final params:{}",JSONObject.toJSONString(dataQuery_AbzcWhereBo));
        BaseDict res = baseDictMapper.dataQuery_Abzc(dataQuery_AbzcWhereBo);


        return res;

    }

    
    static final class BaseDictConstants{


     /***
	 * dataQuery_nTOD use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_NTOD_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};




     /***
	 * dataQuery_Abzc use static constantsPool list
	 */
	public static final MultiValueMap<String, String> DATAQUERY_ABZC_RELATION_TABLE_MAP = new LinkedMultiValueMap<>() {{
	}};


}
}