package com.wlos.app.da.service;


import com.wlos.app.model.SurveyUser;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyUserBO; 
import com.wlos.app.vo.SurveyUserVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_emOBWhereBO;
import com.wlos.app.bo.where.DataQuery_rqVqWhereBO;
import com.wlos.app.bo.where.DataQuery_khZhWhereBO;
import com.wlos.app.bo.where.DataQuery_cHlcWhereBO;/**
 * 用户表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
public interface SurveyUserService extends IService<SurveyUser> {

    /**
     * 根据id查询用户表
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyUser queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyUser> page(Page<SurveyUser> page, SurveyUser condition);


    /**
     * 创建用户表
     *
     * @param surveyUser 用户表载体
     * @return 用户表 新增实体主键
     */
    String insert(SurveyUser surveyUser);
    

    /**
     * 更新用户表
     *
     * @param id 主键id
     * @param surveyUser 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyUser surveyUser);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyUserBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyUserBO surveyUserBo);



    
    /**
     * 流程-查询当前用户信息-数据查询
     * 
     * @param dataQuery_emOBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyUser selectOne(DataQuery_emOBWhereBO dataQuery_emOBWhereBo);


    
    /**
     * 流程-查询用户-数据查询
     * 
     * @param dataQuery_rqVqWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyUser> list(DataQuery_rqVqWhereBO dataQuery_rqVqWhereBo);


    
    /**
     * 流程-根据机构Id和类型查询用户列表-数据查询
     * 
     * @param dataQuery_khZhWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyUser> list(DataQuery_khZhWhereBO dataQuery_khZhWhereBo);


    
    /**
     * 流程-根据bcxToken获取用户信息-数据查询
     * 
     * @param dataQuery_cHlcWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyUser selectOne(DataQuery_cHlcWhereBO dataQuery_cHlcWhereBo);

}