package com.wlos.app.da.service;


import com.wlos.app.model.SurveyTask;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyTaskBO; 
import com.wlos.app.vo.SurveyTaskVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.ModifytskstsdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_dykBWhereBO;
import com.wlos.app.bo.where.DataQuery_EQShWhereBO;
import com.wlos.app.bo.where.DataQueryWhereBO;
import com.wlos.app.bo.DataQueryBO;
import com.wlos.app.bo.where.DataQuery_JvFIWhereBO;
import com.wlos.app.bo.DataqueryJvfiBO;/**
 * 任务信息 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:34 PM
 * @since v0.1
 */
public interface SurveyTaskService extends IService<SurveyTask> {

    /**
     * 根据id查询任务信息
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyTask queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyTask> page(Page<SurveyTask> page, SurveyTask condition);


    /**
     * 创建任务信息
     *
     * @param surveyTask 任务信息载体
     * @return 任务信息 新增实体主键
     */
    String insert(SurveyTask surveyTask);
    

    /**
     * 更新任务信息
     *
     * @param id 主键id
     * @param surveyTask 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyTask surveyTask);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyTaskBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyTaskBO surveyTaskBo);



    
    /**
     * 修改任务状态-数据修改
     * 
     * @param surveyTaskBo 修改参数BO 
     * @param modifytskstsdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyTaskBO surveyTaskBo,ModifytskstsdataModificationWhereBO modifytskstsdataModificationWhereBo);



    
    /**
     * 流程-查询任务详情-数据查询
     * 
     * @param dataQuery_dykBWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyTask selectOne(DataQuery_dykBWhereBO dataQuery_dykBWhereBo);


    
    /**
     * 流程-根据用户id查询进行中的任务列-数据查询
     * 
     * @param dataQuery_EQShWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyTask> list(DataQuery_EQShWhereBO dataQuery_EQShWhereBo);


    
    /**
     * 流程-模糊搜索任务-数据查询
     * 
     * @param dataQueryWhereBo 查询参数BO 
     * @return 查询结果集
     */
    Page<DataQueryBO> page(DataQueryWhereBO dataQueryWhereBo);


    
    /**
     * 流程-不含未接受的任务列表-数据查询
     * 
     * @param dataQuery_JvFIWhereBo 查询参数BO 
     * @return 查询结果集
     */
    Page<DataqueryJvfiBO> page(DataQuery_JvFIWhereBO dataQuery_JvFIWhereBo);

}