package com.wlos.app.da.service;


import com.wlos.app.model.SurveySign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveySignBO; 
import com.wlos.app.vo.SurveySignVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.AddorupdsurveyplancheckindataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_WzkNWhereBO;
import com.wlos.app.bo.where.DataQuery_gUprWhereBO;
import com.wlos.app.bo.where.DataQuery_vyhDWhereBO;/**
 * 勘查签到表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface SurveySignService extends IService<SurveySign> {

    /**
     * 根据id查询勘查签到表
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveySign queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveySign> page(Page<SurveySign> page, SurveySign condition);


    /**
     * 创建勘查签到表
     *
     * @param surveySign 勘查签到表载体
     * @return 勘查签到表 新增实体主键
     */
    String insert(SurveySign surveySign);
    

    /**
     * 更新勘查签到表
     *
     * @param id 主键id
     * @param surveySign 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveySign surveySign);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveySignBo 新增参数 
     * @return 新增id
     */
    String insert(SurveySignBO surveySignBo);



    
    /**
     * 新增或更新踏勘计划签到-数据修改
     * 
     * @param surveySignBo 修改参数BO 
     * @param addorupdsurveyplancheckindataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveySignBO surveySignBo,AddorupdsurveyplancheckindataModificationWhereBO addorupdsurveyplancheckindataModificationWhereBo);



    
    /**
     * 流程-新增或更新踏勘计划签到-数据查询
     * 
     * @param dataQuery_WzkNWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveySign> list(DataQuery_WzkNWhereBO dataQuery_WzkNWhereBo);


    
    /**
     * 流程-踏勘是否签到-数据查询
     * 
     * @param dataQuery_gUprWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveySign> list(DataQuery_gUprWhereBO dataQuery_gUprWhereBo);


    
    /**
     * 流程-根据计划id查询计划信息-数据查询-签到信息
     * 
     * @param dataQuery_vyhDWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveySign selectOne(DataQuery_vyhDWhereBO dataQuery_vyhDWhereBo);

}