package com.wlos.app.da.service;


import com.wlos.app.model.SurveyReform;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyReformBO; 
import com.wlos.app.vo.SurveyReformVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO;/**
 * 回复整改记录表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
public interface SurveyReformService extends IService<SurveyReform> {

    /**
     * 根据id查询回复整改记录表
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyReform queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyReform> page(Page<SurveyReform> page, SurveyReform condition);


    /**
     * 创建回复整改记录表
     *
     * @param surveyReform 回复整改记录表载体
     * @return 回复整改记录表 新增实体主键
     */
    String insert(SurveyReform surveyReform);
    

    /**
     * 更新回复整改记录表
     *
     * @param id 主键id
     * @param surveyReform 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyReform surveyReform);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyReformBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyReformBO surveyReformBo);



        
    /**
     * 根据问卷问题id删除对应记录-数据删除-整改表
     * 
     * @param delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBo 删除参数BO 
     * @return 受影响行数
     */
    Integer delete(DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionRectificationTblWhereBo);


}