package com.wlos.app.da.service;


import com.wlos.app.model.SurveyProjectTemp;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyProjectTempBO; 
import com.wlos.app.vo.SurveyProjectTempVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DelproblemrecordbasedontmpproblemiddataDeletionWhereBO;
import com.wlos.app.bo.where.TmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_TmSjWhereBO;
import com.wlos.app.bo.where.DataQuery_fHTNWhereBO;
import com.wlos.app.bo.where.DataQuery_YsMUWhereBO;/**
 * 问卷题目暂存表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
public interface SurveyProjectTempService extends IService<SurveyProjectTemp> {

    /**
     * 根据id查询问卷题目暂存表
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyProjectTemp queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyProjectTemp> page(Page<SurveyProjectTemp> page, SurveyProjectTemp condition);


    /**
     * 创建问卷题目暂存表
     *
     * @param surveyProjectTemp 问卷题目暂存表载体
     * @return 问卷题目暂存表 新增实体主键
     */
    String insert(SurveyProjectTemp surveyProjectTemp);
    

    /**
     * 更新问卷题目暂存表
     *
     * @param id 主键id
     * @param surveyProjectTemp 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyProjectTemp surveyProjectTemp);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyProjectTempBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyProjectTempBO surveyProjectTempBo);



        
    /**
     * 根据暂存问题id删除问题记录-数据删除
     * 
     * @param delproblemrecordbasedontmpproblemiddataDeletionWhereBo 删除参数BO 
     * @return 受影响行数
     */
    Integer delete(DelproblemrecordbasedontmpproblemiddataDeletionWhereBO delproblemrecordbasedontmpproblemiddataDeletionWhereBo);



    
    /**
     * 新增补充问题暂存-数据修改
     * 
     * @param surveyProjectTempBo 修改参数BO 
     * @param tmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyProjectTempBO surveyProjectTempBo,TmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBO tmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBo);



    
    /**
     * 流程-根据问卷id查询暂存问题-数据查询
     * 
     * @param dataQuery_TmSjWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyProjectTemp> list(DataQuery_TmSjWhereBO dataQuery_TmSjWhereBo);


    
    /**
     * 流程-根据类型和问卷id查询暂存问题-数据查询
     * 
     * @param dataQuery_fHTNWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyProjectTemp> list(DataQuery_fHTNWhereBO dataQuery_fHTNWhereBo);


    
    /**
     * 流程-生成问卷-数据查询-问卷暂存问题
     * 
     * @param dataQuery_YsMUWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<SurveyProjectTemp> list(DataQuery_YsMUWhereBO dataQuery_YsMUWhereBo);

}