package com.wlos.app.da.service;


import com.wlos.app.model.SurveyProject;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyProjectBO; 
import com.wlos.app.vo.SurveyProjectVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO;
import com.wlos.app.bo.where.AddsupplementaryquestionnairequestionrecordsdataModificationWhereBO;/**
 * 勘查项目 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface SurveyProjectService extends IService<SurveyProject> {

    /**
     * 根据id查询勘查项目
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyProject queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyProject> page(Page<SurveyProject> page, SurveyProject condition);


    /**
     * 创建勘查项目
     *
     * @param surveyProject 勘查项目载体
     * @return 勘查项目 新增实体主键
     */
    String insert(SurveyProject surveyProject);
    

    /**
     * 更新勘查项目
     *
     * @param id 主键id
     * @param surveyProject 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyProject surveyProject);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyProjectBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyProjectBO surveyProjectBo);



        
    /**
     * 根据问卷问题id删除对应记录-数据删除-问卷题目
     * 
     * @param delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBo 删除参数BO 
     * @return 受影响行数
     */
    Integer delete(DelcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBO delcorrespondingrecordsbasedonquestionnairequestioniddataDeletionQuestionnaireQuestionsWhereBo);



    
    /**
     * 新增问卷补充问题记录-数据修改
     * 
     * @param surveyProjectBo 修改参数BO 
     * @param addsupplementaryquestionnairequestionrecordsdataModificationWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyProjectBO surveyProjectBo,AddsupplementaryquestionnairequestionrecordsdataModificationWhereBO addsupplementaryquestionnairequestionrecordsdataModificationWhereBo);


}