package com.wlos.app.da.service;


import com.wlos.app.model.SurveyFeedback;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyFeedbackBO; 
import com.wlos.app.vo.SurveyFeedbackVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.ModifyplandataModificationSurveyFeedbackWhereBO;
import com.wlos.app.bo.where.UpdsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO;/**
 * 查勘反馈 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface SurveyFeedbackService extends IService<SurveyFeedback> {

    /**
     * 根据id查询查勘反馈
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyFeedback queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyFeedback> page(Page<SurveyFeedback> page, SurveyFeedback condition);


    /**
     * 创建查勘反馈
     *
     * @param surveyFeedback 查勘反馈载体
     * @return 查勘反馈 新增实体主键
     */
    String insert(SurveyFeedback surveyFeedback);
    

    /**
     * 更新查勘反馈
     *
     * @param id 主键id
     * @param surveyFeedback 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyFeedback surveyFeedback);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyFeedbackBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyFeedbackBO surveyFeedbackBo);



    
    /**
     * 修改计划-数据修改-查勘反馈
     * 
     * @param surveyFeedbackBo 修改参数BO 
     * @param modifyplandataModificationSurveyFeedbackWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyFeedbackBO surveyFeedbackBo,ModifyplandataModificationSurveyFeedbackWhereBO modifyplandataModificationSurveyFeedbackWhereBo);



    
    /**
     * 更新踏勘结果-报告生成未开发-数据修改-查勘反馈状态更新
     * 
     * @param surveyFeedbackBo 修改参数BO 
     * @param updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBo 修改参数BO 
     * @return 受影响行数
     */
    Integer update(SurveyFeedbackBO surveyFeedbackBo,UpdsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBO updsurveyresultsreportgenerationundevelopeddataModificationSurveyFeedbackStsUpdWhereBo);


}