package com.wlos.app.da.service;


import com.wlos.app.model.SurveyExpert;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyExpertBO; 
import com.wlos.app.vo.SurveyExpertVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_KThGWhereBO;/**
 * 踏勘专家记录表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface SurveyExpertService extends IService<SurveyExpert> {

    /**
     * 根据id查询踏勘专家记录表
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyExpert queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyExpert> page(Page<SurveyExpert> page, SurveyExpert condition);


    /**
     * 创建踏勘专家记录表
     *
     * @param surveyExpert 踏勘专家记录表载体
     * @return 踏勘专家记录表 新增实体主键
     */
    String insert(SurveyExpert surveyExpert);
    

    /**
     * 更新踏勘专家记录表
     *
     * @param id 主键id
     * @param surveyExpert 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyExpert surveyExpert);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyExpertBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyExpertBO surveyExpertBo);



    
    /**
     * 流程-计划绑定专家-数据查询-踏勘专家记录
     * 
     * @param dataQuery_KThGWhereBo 查询参数BO 
     * @return 查询结果集
     */
    SurveyExpert selectOne(DataQuery_KThGWhereBO dataQuery_KThGWhereBo);

}