package com.wlos.app.da.service;


import com.wlos.app.model.SurveyAssist;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.SurveyAssistBO; 
import com.wlos.app.vo.SurveyAssistVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_ZzJMWhereBO;
import com.wlos.app.bo.DataqueryZzjmBO;/**
 * 勘查协助 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
public interface SurveyAssistService extends IService<SurveyAssist> {

    /**
     * 根据id查询勘查协助
     *
     * @param id 主键id
     * @return 单条数据
     */
    SurveyAssist queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<SurveyAssist> page(Page<SurveyAssist> page, SurveyAssist condition);


    /**
     * 创建勘查协助
     *
     * @param surveyAssist 勘查协助载体
     * @return 勘查协助 新增实体主键
     */
    String insert(SurveyAssist surveyAssist);
    

    /**
     * 更新勘查协助
     *
     * @param id 主键id
     * @param surveyAssist 实例对象
     * @return 影响行数
     */
    Integer update(String id, SurveyAssist surveyAssist);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param surveyAssistBo 新增参数 
     * @return 新增id
     */
    String insert(SurveyAssistBO surveyAssistBo);



    
    /**
     * 流程-根据任务和阶段查询审批通过的专家-数据查询
     * 
     * @param dataQuery_ZzJMWhereBo 查询参数BO 
     * @return 查询结果集
     */
    DataqueryZzjmBO selectOne(DataQuery_ZzJMWhereBO dataQuery_ZzJMWhereBo);

}