package com.wlos.app.da.service;


import com.wlos.app.model.BaseFixedIssue;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.wlos.app.bo.BaseFixedIssueBO; 
import com.wlos.app.vo.BaseFixedIssueVO; 
import java.util.*;
import com.baomidou.mybatisplus.extension.service.IService;


import com.wlos.app.bo.where.DataQuery_ltrJWhereBO;
import com.wlos.app.bo.where.DataQuery_lINFWhereBO;
import com.wlos.app.bo.where.DataQuery_FuxVWhereBO;
import com.wlos.app.bo.where.DataQuery_dvJRWhereBO;/**
 * 固定问题表 服务接口
 *
 * @author fos
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
public interface BaseFixedIssueService extends IService<BaseFixedIssue> {

    /**
     * 根据id查询固定问题表
     *
     * @param id 主键id
     * @return 单条数据
     */
    BaseFixedIssue queryById(String id);
    
    /**
     * 列表分页条件查询
     * @param page 分页
     * @param condition 条件
     * @return 分页列表
     */
    Page<BaseFixedIssue> page(Page<BaseFixedIssue> page, BaseFixedIssue condition);


    /**
     * 创建固定问题表
     *
     * @param baseFixedIssue 固定问题表载体
     * @return 固定问题表 新增实体主键
     */
    String insert(BaseFixedIssue baseFixedIssue);
    

    /**
     * 更新固定问题表
     *
     * @param id 主键id
     * @param baseFixedIssue 实例对象
     * @return 影响行数
     */
    Integer update(String id, BaseFixedIssue baseFixedIssue);


    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    Integer deleteById(String id);
    

    /**
     * 通过id batch删除数据
     *
     * @param list 主键集
     * @return 影响行数
     */
    int deleteByIds(List<String> list);


    
    /**
     * 通用新增
     * 
     * @param baseFixedIssueBo 新增参数 
     * @return 新增id
     */
    String insert(BaseFixedIssueBO baseFixedIssueBo);



    
    /**
     * 流程-暂存固定和开放问题-数据查询固定问题
     * 
     * @param dataQuery_ltrJWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseFixedIssue> list(DataQuery_ltrJWhereBO dataQuery_ltrJWhereBo);


    
    /**
     * 流程-根据阶段查询固定问题列表-通用问题查询
     * 
     * @param dataQuery_lINFWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseFixedIssue> list(DataQuery_lINFWhereBO dataQuery_lINFWhereBo);


    
    /**
     * 流程-根据阶段查询固定问题列表-根据场地及活动类型查询
     * 
     * @param dataQuery_FuxVWhereBo 查询参数BO 
     * @return 查询结果集
     */
    List<BaseFixedIssue> list(DataQuery_FuxVWhereBO dataQuery_FuxVWhereBo);


    
    /**
     * 流程-根据阶段查询问题数量-数据查询
     * 
     * @param dataQuery_dvJRWhereBo 查询参数BO 
     * @return 查询结果集
     */
    Page<BaseFixedIssue> page(DataQuery_dvJRWhereBO dataQuery_dvJRWhereBo);

}