package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.VenueInformation;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.VenueInformationBO; 
import com.wlos.app.vo.VenueInformationVO; 


import com.wlos.app.bo.where.DataQuery_WxdwWhereBO;
import com.wlos.app.bo.where.DataQuery_NIUaWhereBO;
import com.wlos.app.bo.where.ModifyvenueinformationdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_HwicWhereBO;

/**
 * 场馆信息 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:35 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface VenueInformationMapper extends BaseMapper<VenueInformation> {
      
   /**
    * 流程-根据场馆id查询场馆信息-数据查询
    * @param dataQuery_WxdwWhereBo 查询参数BO 
    * @return 查询结果集
    */
    VenueInformation dataQuery_Wxdw(@Param("where") DataQuery_WxdwWhereBO dataQuery_WxdwWhereBo);



      
   /**
    * 流程-根据区域查询场馆列表-数据查询
    * @param dataQuery_NIUaWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<VenueInformation> dataQuery_NIUa(@Param("where") DataQuery_NIUaWhereBO dataQuery_NIUaWhereBo);



 
   /**
    * 修改场馆信息-数据修改
    * @param venueInformationBo 修改参数BO 
    * @param modifyvenueinformationdataModificationWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer modifyvenueinformationdataModification(@Param("update")VenueInformationBO venueInformationBo,@Param("where")ModifyvenueinformationdataModificationWhereBO modifyvenueinformationdataModificationWhereBo);

  

      
   /**
    * 流程-修改场馆信息-数据查询
    * @param dataQuery_HwicWhereBo 查询参数BO 
    * @return 查询结果集
    */
    VenueInformation dataQuery_Hwic(@Param("where") DataQuery_HwicWhereBO dataQuery_HwicWhereBo);




}