package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveyUser;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveyUserBO; 
import com.wlos.app.vo.SurveyUserVO; 


import com.wlos.app.bo.where.DataQuery_emOBWhereBO;
import com.wlos.app.bo.where.DataQuery_rqVqWhereBO;
import com.wlos.app.bo.where.DataQuery_khZhWhereBO;
import com.wlos.app.bo.where.DataQuery_cHlcWhereBO;

/**
 * 用户表 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveyUserMapper extends BaseMapper<SurveyUser> {
      
   /**
    * 流程-查询当前用户信息-数据查询
    * @param dataQuery_emOBWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyUser dataQuery_emOB(@Param("where") DataQuery_emOBWhereBO dataQuery_emOBWhereBo);



      
   /**
    * 流程-查询用户-数据查询
    * @param dataQuery_rqVqWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyUser> dataQuery_rqVq(@Param("where") DataQuery_rqVqWhereBO dataQuery_rqVqWhereBo);



      
   /**
    * 流程-根据机构Id和类型查询用户列表-数据查询
    * @param dataQuery_khZhWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyUser> dataQuery_khZh(@Param("where") DataQuery_khZhWhereBO dataQuery_khZhWhereBo);



      
   /**
    * 流程-根据bcxToken获取用户信息-数据查询
    * @param dataQuery_cHlcWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyUser dataQuery_cHlc(@Param("where") DataQuery_cHlcWhereBO dataQuery_cHlcWhereBo);




}