package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveyTag;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveyTagBO; 
import com.wlos.app.vo.SurveyTagVO; 


import com.wlos.app.bo.where.DataQuery_RSqBWhereBO;
import com.wlos.app.bo.where.DataQuery_ufRXWhereBO;
import com.wlos.app.bo.where.DataQuery_eHuGWhereBO;

/**
 * 标签表 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveyTagMapper extends BaseMapper<SurveyTag> {
      
   /**
    * 流程-标签列表查询-数据查询-查询标签
    * @param dataQuery_RSqBWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyTag> dataQuery_RSqB(@Param("where") DataQuery_RSqBWhereBO dataQuery_RSqBWhereBo);



      
   /**
    * 流程-根据分类id查询分类名称-数据查询
    * @param dataQuery_ufRXWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyTag dataQuery_ufRX(@Param("where") DataQuery_ufRXWhereBO dataQuery_ufRXWhereBo);



      
   /**
    * 流程-根据父级id查询标签列表-数据查询-标签列表
    * @param dataQuery_eHuGWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyTag> dataQuery_eHuG(@Param("where") DataQuery_eHuGWhereBO dataQuery_eHuGWhereBo);




}