package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveySign;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveySignBO; 
import com.wlos.app.vo.SurveySignVO; 


import com.wlos.app.bo.where.AddorupdsurveyplancheckindataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_WzkNWhereBO;
import com.wlos.app.bo.where.DataQuery_gUprWhereBO;
import com.wlos.app.bo.where.DataQuery_vyhDWhereBO;

/**
 * 勘查签到表 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveySignMapper extends BaseMapper<SurveySign> {
 
   /**
    * 新增或更新踏勘计划签到-数据修改
    * @param surveySignBo 修改参数BO 
    * @param addorupdsurveyplancheckindataModificationWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer addorupdsurveyplancheckindataModification(@Param("update")SurveySignBO surveySignBo,@Param("where")AddorupdsurveyplancheckindataModificationWhereBO addorupdsurveyplancheckindataModificationWhereBo);

  

      
   /**
    * 流程-新增或更新踏勘计划签到-数据查询
    * @param dataQuery_WzkNWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveySign> dataQuery_WzkN(@Param("where") DataQuery_WzkNWhereBO dataQuery_WzkNWhereBo);



      
   /**
    * 流程-踏勘是否签到-数据查询
    * @param dataQuery_gUprWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveySign> dataQuery_gUpr(@Param("where") DataQuery_gUprWhereBO dataQuery_gUprWhereBo);



      
   /**
    * 流程-根据计划id查询计划信息-数据查询-签到信息
    * @param dataQuery_vyhDWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveySign dataQuery_vyhD(@Param("where") DataQuery_vyhDWhereBO dataQuery_vyhDWhereBo);




}