package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveyProjectTemp;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveyProjectTempBO; 
import com.wlos.app.vo.SurveyProjectTempVO; 


import com.wlos.app.bo.where.DelproblemrecordbasedontmpproblemiddataDeletionWhereBO;
import com.wlos.app.bo.where.TmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBO;
import com.wlos.app.bo.where.DataQuery_TmSjWhereBO;
import com.wlos.app.bo.where.DataQuery_fHTNWhereBO;
import com.wlos.app.bo.where.DataQuery_YsMUWhereBO;

/**
 * 问卷题目暂存表 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveyProjectTempMapper extends BaseMapper<SurveyProjectTemp> {
 
   /**
    * 根据暂存问题id删除问题记录-数据删除
    * @return 受影响行数
    */
    Integer delproblemrecordbasedontmpproblemiddataDeletion(DelproblemrecordbasedontmpproblemiddataDeletionWhereBO delproblemrecordbasedontmpproblemiddataDeletionWhereBo);

     

 
   /**
    * 新增补充问题暂存-数据修改
    * @param surveyProjectTempBo 修改参数BO 
    * @param tmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer tmpstgofnewlyaddedsupplementaryquestionsdataModification(@Param("update")SurveyProjectTempBO surveyProjectTempBo,@Param("where")TmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBO tmpstgofnewlyaddedsupplementaryquestionsdataModificationWhereBo);

  

      
   /**
    * 流程-根据问卷id查询暂存问题-数据查询
    * @param dataQuery_TmSjWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyProjectTemp> dataQuery_TmSj(@Param("where") DataQuery_TmSjWhereBO dataQuery_TmSjWhereBo);



      
   /**
    * 流程-根据类型和问卷id查询暂存问题-数据查询
    * @param dataQuery_fHTNWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyProjectTemp> dataQuery_fHTN(@Param("where") DataQuery_fHTNWhereBO dataQuery_fHTNWhereBo);



      
   /**
    * 流程-生成问卷-数据查询-问卷暂存问题
    * @param dataQuery_YsMUWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyProjectTemp> dataQuery_YsMU(@Param("where") DataQuery_YsMUWhereBO dataQuery_YsMUWhereBo);




}