package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.SurveyPlan;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.SurveyPlanBO; 
import com.wlos.app.vo.SurveyPlanVO; 


import com.wlos.app.bo.where.DataQuery_BsWDWhereBO;
import com.wlos.app.bo.where.DataQuery_bAiCWhereBO;
import com.wlos.app.bo.where.UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO;
import com.wlos.app.bo.where.UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO;
import com.wlos.app.bo.where.ModifyplandataModificationPlanWhereBO;
import com.wlos.app.bo.where.GenquestionnairedataModificationPlanStsWhereBO;
import com.wlos.app.bo.where.DataQuery_aiPC_GqBoWhereBO;
import com.wlos.app.bo.where.DataQuery_zloFWhereBO;
import com.wlos.app.bo.where.DataQuery_okFgWhereBO;
import com.wlos.app.bo.where.DataQuery_sOdzWhereBO;
import com.wlos.app.bo.where.DataQuery_CncCWhereBO;
import com.wlos.app.bo.where.DataQuery_AuHNWhereBO;
import com.wlos.app.bo.DataqueryAuhnBO;
import com.wlos.app.bo.where.DataQuery_rMQqWhereBO;
import com.wlos.app.bo.DataqueryRmqqBO;
import com.wlos.app.bo.where.DataQuery_BcEjWhereBO;
import com.wlos.app.bo.DataqueryBcejBO;
import com.wlos.app.bo.where.DataQuery_aiPCWhereBO;
import com.wlos.app.bo.DataqueryAipcBO;
import com.wlos.app.bo.where.DataQuery_gsTWWhereBO;
import com.wlos.app.bo.DataqueryGstwBO;

/**
 * 勘查计划 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:28 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface SurveyPlanMapper extends BaseMapper<SurveyPlan> {
      
   /**
    * 流程-根据问卷id查询计划-数据查询
    * @param dataQuery_BsWDWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyPlan dataQuery_BsWD(@Param("where") DataQuery_BsWDWhereBO dataQuery_BsWDWhereBo);



      
   /**
    * 流程-根据任务id查询踏勘计划次数-数据查询
    * @param dataQuery_bAiCWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyPlan> dataQuery_bAiC(@Param("where") DataQuery_bAiCWhereBO dataQuery_bAiCWhereBo);



 
   /**
    * 更新计划签名-数据修改-踏勘人员签名
    * @param surveyPlanBo 修改参数BO 
    * @param updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer updplansignaturedataModificationSignatureOfSurveyPersonnel(@Param("update")SurveyPlanBO surveyPlanBo,@Param("where")UpdplansignaturedataModificationSignatureOfSurveyPersonnelWhereBO updplansignaturedataModificationSignatureOfSurveyPersonnelWhereBo);

  

 
   /**
    * 更新计划签名-数据修改-承办方签名
    * @param surveyPlanBo 修改参数BO 
    * @param updplansignaturedataModificationSignatureOfTheOrganizerWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer updplansignaturedataModificationSignatureOfTheOrganizer(@Param("update")SurveyPlanBO surveyPlanBo,@Param("where")UpdplansignaturedataModificationSignatureOfTheOrganizerWhereBO updplansignaturedataModificationSignatureOfTheOrganizerWhereBo);

  

 
   /**
    * 修改计划-数据修改-计划
    * @param surveyPlanBo 修改参数BO 
    * @param modifyplandataModificationPlanWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer modifyplandataModificationPlan(@Param("update")SurveyPlanBO surveyPlanBo,@Param("where")ModifyplandataModificationPlanWhereBO modifyplandataModificationPlanWhereBo);

  

 
   /**
    * 生成问卷-数据修改-计划状态
    * @param surveyPlanBo 修改参数BO 
    * @param genquestionnairedataModificationPlanStsWhereBo 修改参数BO 
    * @return 受影响行数
    */
    Integer genquestionnairedataModificationPlanSts(@Param("update")SurveyPlanBO surveyPlanBo,@Param("where")GenquestionnairedataModificationPlanStsWhereBO genquestionnairedataModificationPlanStsWhereBo);

  

      
   /**
    * 流程-根据计划id查询计划-数据查询
    * @param dataQuery_aiPC_GqBoWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyPlan dataQuery_aiPC_GqBo(@Param("where") DataQuery_aiPC_GqBoWhereBO dataQuery_aiPC_GqBoWhereBo);



      
   /**
    * 流程-根据计划id和问题类型查询问题列表-数据查询-计划
    * @param dataQuery_zloFWhereBo 查询参数BO 
    * @return 查询结果集
    */
    SurveyPlan dataQuery_zloF(@Param("where") DataQuery_zloFWhereBO dataQuery_zloFWhereBo);



      
   /**
    * 流程-根据任务id查询最大计划次数-数据查询-倒序查询次数
    * @param dataQuery_okFgWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyPlan> dataQuery_okFg(@Param("where") DataQuery_okFgWhereBO dataQuery_okFgWhereBo);



      
   /**
    * 流程-根据任务id和次数查询勘查计划-数据查询
    * @param dataQuery_sOdzWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyPlan> dataQuery_sOdz(@Param("where") DataQuery_sOdzWhereBO dataQuery_sOdzWhereBo);



      
   /**
    * 流程-根据任务id查询次数列表-数据查询
    * @param dataQuery_CncCWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<SurveyPlan> dataQuery_CncC(@Param("where") DataQuery_CncCWhereBO dataQuery_CncCWhereBo);



      
   /**
    * 流程-更新踏勘结果-报告生成未开发-数据查询-未作答题目记录
    * @param dataQuery_AuHNWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<DataqueryAuhnBO> dataQuery_AuHN(@Param("where") DataQuery_AuHNWhereBO dataQuery_AuHNWhereBo);



      
   /**
    * 流程-问卷设计列表查询-数据查询-计划列表
    * @param dataQuery_rMQqWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<DataqueryRmqqBO> dataQuery_rMQq(@Param("where") DataQuery_rMQqWhereBO dataQuery_rMQqWhereBo);



      
   /**
    * 流程-根据年月份查询未完成的任务列表-数据查询
    * @param dataQuery_BcEjWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<DataqueryBcejBO> dataQuery_BcEj(@Param("where") DataQuery_BcEjWhereBO dataQuery_BcEjWhereBo);



      
   /**
    * 流程-根据计划id查询计划详情-数据查询
    * @param dataQuery_aiPCWhereBo 查询参数BO 
    * @return 查询结果集
    */
    DataqueryAipcBO dataQuery_aiPC(@Param("where") DataQuery_aiPCWhereBO dataQuery_aiPCWhereBo);



      
   /**
    * 流程-根据计划id查询计划信息-数据查询-踏勘计划
    * @param dataQuery_gsTWWhereBo 查询参数BO 
    * @return 查询结果集
    */
    DataqueryGstwBO dataQuery_gsTW(@Param("where") DataQuery_gsTWWhereBO dataQuery_gsTWWhereBo);




}