package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.BaseOpenIssue;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.BaseOpenIssueBO; 
import com.wlos.app.vo.BaseOpenIssueVO; 


import com.wlos.app.bo.where.DataQuery_vikAWhereBO;
import com.wlos.app.bo.where.DataQuery_hYiGWhereBO;

/**
 * 开放问题表 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface BaseOpenIssueMapper extends BaseMapper<BaseOpenIssue> {
      
   /**
    * 流程-暂存固定和开放问题-数据查询开发
    * @param dataQuery_vikAWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<BaseOpenIssue> dataQuery_vikA(@Param("where") DataQuery_vikAWhereBO dataQuery_vikAWhereBo);



      
   /**
    * 流程-根据层级和名称查询开放问题列表-数据查询
    * @param dataQuery_hYiGWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<BaseOpenIssue> dataQuery_hYiG(@Param("where") DataQuery_hYiGWhereBO dataQuery_hYiGWhereBo);




}