package com.wlos.app.da.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wlos.app.model.BaseFixedIssue;
import java.util.*;
import org.apache.ibatis.annotations.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Repository;    
import com.wlos.app.bo.BaseFixedIssueBO; 
import com.wlos.app.vo.BaseFixedIssueVO; 


import com.wlos.app.bo.where.DataQuery_ltrJWhereBO;
import com.wlos.app.bo.where.DataQuery_lINFWhereBO;
import com.wlos.app.bo.where.DataQuery_FuxVWhereBO;
import com.wlos.app.bo.where.DataQuery_dvJRWhereBO;

/**
 * 固定问题表 表数据库访问层
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Mapper
@Repository
public interface BaseFixedIssueMapper extends BaseMapper<BaseFixedIssue> {
      
   /**
    * 流程-暂存固定和开放问题-数据查询固定问题
    * @param dataQuery_ltrJWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<BaseFixedIssue> dataQuery_ltrJ(@Param("where") DataQuery_ltrJWhereBO dataQuery_ltrJWhereBo);



      
   /**
    * 流程-根据阶段查询固定问题列表-通用问题查询
    * @param dataQuery_lINFWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<BaseFixedIssue> dataQuery_lINF(@Param("where") DataQuery_lINFWhereBO dataQuery_lINFWhereBo);



      
   /**
    * 流程-根据阶段查询固定问题列表-根据场地及活动类型查询
    * @param dataQuery_FuxVWhereBo 查询参数BO 
    * @return 查询结果集
    */
    List<BaseFixedIssue> dataQuery_FuxV(@Param("where") DataQuery_FuxVWhereBO dataQuery_FuxVWhereBo);



      
   /**
    * 流程-根据阶段查询问题数量-数据查询
    * @param dataQuery_dvJRWhereBo 查询参数BO 
    * @return 查询结果集
    */
    Page<BaseFixedIssue> dataQuery_dvJR(Page<BaseFixedIssue> page,@Param("where") DataQuery_dvJRWhereBO dataQuery_dvJRWhereBo);




}