package com.wlos.app.bo;

import java.io.Serializable;
import java.io.Serial;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 用户表 数据操作通用BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Data
public class SurveyUserBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 是否激活
     */
    private String active;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 电话
     */
    private String phone;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 用户类型(1:踏勘人员;2:专家人员;3.两者都有)
     */
    private String userType;

    /**
     * 对应机构ID
     */
    private Long orgId;

    /**
     * 专家来源:public,private
     */
    private String source;

    /**
     * 专家标签:现场专家,远程专家,咨询专家
     */
    private String expertTag;

    /**
     * v5雇员Id
     */
    private String v5_employee_id;



}