package com.wlos.app.bo;

import java.io.Serializable;
import java.io.Serial;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 标签表 数据操作通用BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:25 PM
 * @since v0.1
 */
@Data
public class SurveyTagBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 标签等级
     */
    private Integer level;

    /**
     * 标签名
     */
    private String name;

    /**
     * 上级标签ID
     */
    private Long parentId;

    /**
     * 标签类型
     */
    private String tagType;



}