package com.wlos.app.bo;

import java.io.Serializable;
import java.io.Serial;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 勘查项目 数据操作通用BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Data
public class SurveyProjectBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * CMS中对应的问题ID
     */
    private String aid;

    /**
     * 结果提示
     */
    private String answerTip;

    /**
     * 踏勘题目
     */
    private String question;

    /**
     * 问题类型
     */
    private String questionType;

    /**
     * 排序编号
     */
    private Long sort;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 问题回答id
     */
    private Long survey_info_id;



}