package com.wlos.app.bo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 流程-根据计划id查询计划详情-数据查询 表关联BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:04:00 PM
 * @since v0.1
 */
@Data
public class DataqueryAipcBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 地址类型
     */
    private String address_type;

    /**
     * 活动类型
     */
    private String activity_type;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 总共天数
     */
    private Boolean allDay;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 场地ID
     */
    private Long venueId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 踏勘任务ID
     */
    private Long taskId;

    /**
     * 对应踏勘阶段
     */
    private Long feedbackId;

    /**
     * 踏勘次数
     */
    private Integer time;

    /**
     * 踏勘状态
     */
    private String taskStatus;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 客户经理签字
     */
    private String signImgPath;

    /**
     * 备注
     */
    private String remark;

    /**
     * 承办方负责人签字
     */
    private String purveyorSignPath;

    /**
     * 踏勘结束时间
     */
    private LocalDateTime endTime;

    /**
     * 踏勘开始时间
     */
    private LocalDateTime beginTime;

    /**
     * 对应踏勘场地问题
     */
    private Long questionnaireId;

    /**
     * 场馆名称
     */
    private String venueName;



}

