package com.wlos.app.bo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 流程-模糊搜索任务-数据查询 表关联BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:59 PM
 * @since v0.1
 */
@Data
public class DataQueryBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * v5雇员Id
     */
    private String v5_employee_id;

    /**
     * 专家标签:现场专家,远程专家,咨询专家
     */
    private String expertTag;

    /**
     * 专家来源:public,private
     */
    private String source;

    /**
     * 对应机构ID
     */
    private Long orgId;

    /**
     * 用户类型(1:踏勘人员;2:专家人员;3.两者都有)
     */
    private String userType;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 是否激活
     */
    private String active;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime_ZfvA;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime_BWxI;

    /**
     * 主键id
     */
    private String id_emyI;

    /**
     * 市编码
     */
    private String city;

    /**
     * 省编码
     */
    private String province;

    /**
     * 地址类型
     */
    private String address_type;

    /**
     * 活动类型
     */
    private String activity_type;

    /**
     * 主站任务ID
     */
    private Long taskId;

    /**
     * 场馆ID
     */
    private Long venueId;

    /**
     * 踏勘人员ID
     */
    private Long userId;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 接受时间
     */
    private LocalDateTime acceptTime;

    /**
     * 状态（0:未接受;1:进行中;2:已办结;2:已办结;3:退回;9:已超时;）
     */
    private String surveyTaskStatus;

    /**
     * 联系电话
     */
    private String contactMobile;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 活动地址
     */
    private String address;

    /**
     * 活动结束时间
     */
    private LocalDateTime endTime;

    /**
     * 活动开始时间
     */
    private LocalDateTime starTime;

    /**
     * 活动ID
     */
    private Long activityId;



}

