package com.wlos.app.bo;

import java.io.Serializable;
import java.io.Serial;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.time.*;
import com.wlos.app.dto.CommonFileDTO;

/**
 * 地区表 数据操作通用BO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Data
public class BaseRegionBO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键ID
     */
    private String id;

    /**
     * 区
     */
    private String area;

    /**
     * 市/县
     */
    private String city;

    /**
     * 父级编码
     */
    private String parentId;

    /**
     * 省
     */
    private String province;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 区域级别
     */
    private String level;

    /**
     * 别名
     */
    private String alias;

    /**
     * 排序
     */
    private Integer seq;



}