package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import java.util.stream.Collectors;
import com.wlos.app.bo.where.*;
import com.wlos.app.da.service.SurveyInfoService;
import com.wlos.app.bo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
/**
* 更新问题回答信息
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class UpdQuestionAnswerInformationService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "更新问题回答信息";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyInfoService surveyInfoService;
    @Autowired
    private QueryQuestionInformationBasedOnAnswerIDService queryQuestionInformationBasedOnAnswerIDService;    @Autowired
    private NxtQuestionService nxtQuestionService;    @Autowired
    private GatewayMatchService gatewayMatchService;
    /**
    * 更新问题回答信息接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public JSONObject processMainExecute(UpdQuestionAnswerInformationDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        UpdQuestionAnswerInformationBO bo = new UpdQuestionAnswerInformationBO();
        if (Objects.isNull(form)) {
            form = new UpdQuestionAnswerInformationDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"answerIDForTheNxtQuestion","abnormalInformation",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("answerIDForTheNxtQuestion",boMap.get("answerIDForTheNxtQuestion"));
                vo.put("abnormalInformation",boMap.get("abnormalInformation"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        branch(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据修改
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataModification(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行数据修改方法=======");
        UpdQuestionAnswerInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据修改,输入参数: {}",processName,JSON.toJSONString(bo));
        //处理请求参数
        JSONObject paramMap = new JSONObject();
                String answerCont0 = bo.getAnswerCont();
                paramMap.put("answer", answerCont0);
                Integer theExtremelyShortIntegerIs1 = ElementConstants.theExtremelyShortIntegerIs;
                paramMap.put("replied", theExtremelyShortIntegerIs1);
                String addAttachmentCol2 = bo.getAddAttachmentCol();
                paramMap.put("urls", addAttachmentCol2);

        JSONObject whereParamMap = new JSONObject();
                String operationAnswerIdToStringConversion3 = bo.getOperationAnswerIdToStringConversion();
                whereParamMap.put("surveyInfoId", operationAnswerIdToStringConversion3);

        //调用数据修改
        log.info("============dm paramMap===" + paramMap.toJSONString());
        SurveyInfoBO surveyInfoBO = BeanUtil.mapToBean(paramMap, SurveyInfoBO.class, null);
        UpdquestionanswerinformationdataModificationWhereBO updquestionanswerinformationdataModificationWhereBO = BeanUtil.mapToBean(whereParamMap, UpdquestionanswerinformationdataModificationWhereBO.class, null);
        Integer vo = surveyInfoService.update(surveyInfoBO, updquestionanswerinformationdataModificationWhereBO);
        bo.setDataModification(vo);
        log.debug("流程名称：{},方法名称: 数据修改,输出参数: {}",processName,JSON.toJSONString(vo));
        synchronizeRefProcIssueInformation(paramsJsonContext, executeBO);
    }

    /**
    * 运算-回答id转字符串
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void operationAnswerIdToStringConversion(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        UpdQuestionAnswerInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-回答id转字符串,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nJSON.stringify(u_biz_flow_v2_input_param_U_075c0ec260ec44848d0b9a52abca7557_u);\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_input_param_U_075c0ec260ec44848d0b9a52abca7557_u";
        String bindType0 = "BigInteger";
        Long bindValue0 = bo.getAnswerID();
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        String vo = String.valueOf(evalValue);
        bo.setOperationAnswerIdToStringConversion(vo);
        log.debug("流程名称：{},方法名称: 运算-回答id转字符串,输出参数: {}",processName,JSON.toJSONString(vo));
        dataModification(paramsJsonContext, executeBO);
    }

    /**
    * 同步引用流程-问题信息
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronizeRefProcIssueInformation(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        UpdQuestionAnswerInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程-问题信息,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                Long answerID0 = bo.getAnswerID();
                jsonObjectNewParam.put("answerID", answerID0);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronizeRefProcIssueInformationExecSub(BeanUtil.mapToBean(jsonObjectNewParam, QueryQuestionInformationBasedOnAnswerIDDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        QueryQuestionInformationBasedOnAnswerIDVO vo = JSON.parseObject(JSON.toJSONString(voObj),QueryQuestionInformationBasedOnAnswerIDVO.class);
        bo.setSynchronizeRefProcIssueInformation(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程-问题信息,输出参数: {}",processName,JSON.toJSONString(vo));
        synchronousRefProc_lHoR(paramsJsonContext, executeBO);
    }

    JSONObject synchronizeRefProcIssueInformationExecSub(QueryQuestionInformationBasedOnAnswerIDDTO form) throws BusinessException {
        return queryQuestionInformationBasedOnAnswerIDService.processMainExecute(form);
    }

    /**
    * 同步引用流程
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void synchronousRefProc_lHoR(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行引用子过程方法=======");
        UpdQuestionAnswerInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 同步引用流程,输入参数: {}",processName,JSON.toJSONString(bo));
        //调用方法参数
        Map<String, Object> jsonObjectNewParam = new HashMap<>();
                String problemInformation0 = null;
                jsonObjectNewParam.put("problemType", problemInformation0);
                Long problemInformation1 = null;
                jsonObjectNewParam.put("questionnaireID", problemInformation1);
                Long problemInformation2 = null;
                jsonObjectNewParam.put("serialNum", problemInformation2);
        log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
        //调用子流程处理
        //取返回结果
        JSONObject voObj =synchronousRefProc_lHoRExecSub(BeanUtil.mapToBean(jsonObjectNewParam, NxtQuestionDTO.class, null));
        if (null != voObj) {
            voObj.remove("system_returnBelong");
            voObj.remove("system_flow_down_file_flag");
        }
        NxtQuestionVO vo = JSON.parseObject(JSON.toJSONString(voObj),NxtQuestionVO.class);
        bo.setSynchronousRefProc_lHoR(vo);
        log.debug("流程名称：{},方法名称: 同步引用流程,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment(paramsJsonContext, executeBO);
    }

    JSONObject synchronousRefProc_lHoRExecSub(NxtQuestionDTO form) throws BusinessException {
        return nxtQuestionService.processMainExecute(form);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        UpdQuestionAnswerInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String nxtQuestionIDtxxrw0 = bo.getSynchronousRefProc_lHoR().getNxtQuestionID();
        bo.setAnswerIDForTheNxtQuestion(nxtQuestionIDtxxrw0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchOperationAnswerIdToStringConversion(paramsJsonContext, executeBO)){
            operationAnswerIdToStringConversion(paramsJsonContext, executeBO);
        }
        else {
            paramAssignmentUnansweredExcep(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchOperationAnswerIdToStringConversion(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            UpdQuestionAnswerInformationBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            String answerCont = bo.getAnswerCont();
            boolean matchState = (((ObjectUtils.isNotEmpty(answerCont))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值-未回答异常
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignmentUnansweredExcep(JSONObject paramsJsonContext, UpdQuestionAnswerInformationBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        UpdQuestionAnswerInformationBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值-未回答异常,输入参数: {}",processName,JSON.toJSONString(bo));
        String nrupc0 = "回答内容不能为空";
        bo.setAbnormalInformation(nrupc0);
        endEvent(paramsJsonContext, executeBO);
    }

}