package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
/**
* 暂存补充问题
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class TmpStgSupplementIssueService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "暂存补充问题";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private TmpStgOfNewlyAddedSupplementaryQuestionsService tmpStgOfNewlyAddedSupplementaryQuestionsService;

    /**
    * 暂存补充问题接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(TmpStgSupplementIssueDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        TmpStgSupplementIssueBO bo = new TmpStgSupplementIssueBO();
        if (Objects.isNull(form)) {
            form = new TmpStgSupplementIssueDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //循环
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, TmpStgSupplementIssueBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        loop(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, TmpStgSupplementIssueBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 循环
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void loop(JSONObject paramsJsonContext, TmpStgSupplementIssueBO executeBO) throws BusinessException {
        log.info("========执行循环调用过程方法=======");
        TmpStgSupplementIssueBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 循环,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONArray vo = new JSONArray();
        List loopArray = bo.getProblemLst();
        //获取需要循环的内容
        //执行循环
        if (CollectionUtils.isNotEmpty(loopArray)) {
            log.info("=============循环的数据有数据，准备执行循环子流程处理=================");
            for (int i = 0; i < loopArray.size(); i++) {
                //初始化下一个流程需要的data数据
                Map<String, Object> jsonObjectNewParam = new HashMap<>();
                Object problemLst0 =  loopArray.get(i);
                jsonObjectNewParam.put("subject", problemLst0);
                Long questionnaireID1 = bo.getQuestionnaireID();
                jsonObjectNewParam.put("questionnaireID", questionnaireID1);
                log.info("==============jsonObjectNewParam==" + JSON.toJSONString(jsonObjectNewParam));
                JSONObject returnDataJson = tmpStgOfNewlyAddedSupplementaryQuestionsService.processMainExecute(BeanUtil.mapToBean(jsonObjectNewParam, TmpStgOfNewlyAddedSupplementaryQuestionsDTO.class, null));
                //取返回结果
                if (null != returnDataJson) {
                    returnDataJson.remove("system_returnBelong");
                    returnDataJson.remove("system_flow_down_file_flag");
                }
                vo.add(returnDataJson);
            }
        } else {
            log.info("=============循环的数据为空，不执行循环子流程处理=================");
        }
        bo.setLoop(vo);
        endEvent(paramsJsonContext, executeBO);
    }

}