
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyUserAggregateServiceImpl implements SurveyUserAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyUserService surveyUserService;


    /**
    * 聚合查询：查询当前用户信息-数据查询
    * @return
    */
    @Override
    public SurveyUser dataQuery_emOB(JSONObject paramsJsonContext,QueryCurUserInformationBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String redisQuery0 = bo.getRedisQuery();
        queryParams.put("surveyUserId", redisQuery0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_emOBWhereBO dataQuery_emOBWhereBO = BeanUtil.toBean(queryParams, DataQuery_emOBWhereBO.class);
        SurveyUser queryResult = surveyUserService.selectOne(dataQuery_emOBWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：查询用户-数据查询
    * @return
    */
    @Override
    public List<SurveyUser> dataQuery_rqVq(JSONObject paramsJsonContext,QueryUsersBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Object griez0 = "1";
        queryParams.put("surveyUserActive", griez0);
        String userID1 = bo.getUserID();
        queryParams.put("surveyUserId", userID1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_rqVqWhereBO dataQuery_rqVqWhereBO = BeanUtil.toBean(queryParams, DataQuery_rqVqWhereBO.class);
        List<SurveyUser> queryResult = surveyUserService.list(dataQuery_rqVqWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据机构Id和类型查询用户列表-数据查询
    * @return
    */
    @Override
    public List<SurveyUser> dataQuery_khZh(JSONObject paramsJsonContext,QueryUserLstBasedOnInstitutionIDAndTypeBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long orgId0 = bo.getSynchronousRefProc().getUserDetails().getOrgId();
        queryParams.put("surveyUserOrgId", orgId0);
        String redisQuery1 = bo.getRedisQuery();
        queryParams.put("surveyUserId", redisQuery1);
        String customerType2 = bo.getCustomerType();
        queryParams.put("surveyUserUserType", customerType2);
        Object gpuxw3 = "3";
        queryParams.put("surveyUserUserType1", gpuxw3);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_khZhWhereBO dataQuery_khZhWhereBO = BeanUtil.toBean(queryParams, DataQuery_khZhWhereBO.class);
        List<SurveyUser> queryResult = surveyUserService.list(dataQuery_khZhWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据bcxToken获取用户信息-数据查询
    * @return
    */
    @Override
    public SurveyUser dataQuery_cHlc(JSONObject paramsJsonContext,ObtainUserInformationBasedOnBcxTokenBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String bcxToken0 = bo.getBcxToken();
        queryParams.put("surveyUserV5_employee_id", bcxToken0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_cHlcWhereBO dataQuery_cHlcWhereBO = BeanUtil.toBean(queryParams, DataQuery_cHlcWhereBO.class);
        SurveyUser queryResult = surveyUserService.selectOne(dataQuery_cHlcWhereBO);
        return queryResult;
    }


}