
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveySignAggregateServiceImpl implements SurveySignAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveySignService surveySignService;


    /**
    * 聚合查询：新增或更新踏勘计划签到-数据查询
    * @return
    */
    @Override
    public List<SurveySign> dataQuery_WzkN(JSONObject paramsJsonContext,AddOrUpdSurveyPlanCheckinBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String planID0 = bo.getPlanID();
        queryParams.put("surveySignPlanId", planID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_WzkNWhereBO dataQuery_WzkNWhereBO = BeanUtil.toBean(queryParams, DataQuery_WzkNWhereBO.class);
        List<SurveySign> queryResult = surveySignService.list(dataQuery_WzkNWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：踏勘是否签到-数据查询
    * @return
    */
    @Override
    public List<SurveySign> dataQuery_gUpr(JSONObject paramsJsonContext,ChkIfThereIsASignInDuringTheInspectionBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String planID0 = bo.getPlanID();
        queryParams.put("surveySignId", planID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_gUprWhereBO dataQuery_gUprWhereBO = BeanUtil.toBean(queryParams, DataQuery_gUprWhereBO.class);
        List<SurveySign> queryResult = surveySignService.list(dataQuery_gUprWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据计划id查询计划信息-数据查询-签到信息
    * @return
    */
    @Override
    public SurveySign dataQuery_vyhD(JSONObject paramsJsonContext,QueryPlanInformationBasedOnPlanIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        String planID0 = bo.getPlanID();
        queryParams.put("surveySignPlanId", planID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_vyhDWhereBO dataQuery_vyhDWhereBO = BeanUtil.toBean(queryParams, DataQuery_vyhDWhereBO.class);
        SurveySign queryResult = surveySignService.selectOne(dataQuery_vyhDWhereBO);
        return queryResult;
    }


}