
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyProjectTempAggregateServiceImpl implements SurveyProjectTempAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyProjectTempService surveyProjectTempService;


    /**
    * 聚合查询：根据问卷id查询暂存问题-数据查询
    * @return
    */
    @Override
    public List<SurveyProjectTemp> dataQuery_TmSj(JSONObject paramsJsonContext,QueryTmpStgIssuesBasedOnQuestionnaireIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long questionnaireID0 = bo.getQuestionnaireID();
        queryParams.put("surveyProjectTempQuestionnaireId", questionnaireID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_TmSjWhereBO dataQuery_TmSjWhereBO = BeanUtil.toBean(queryParams, DataQuery_TmSjWhereBO.class);
        List<SurveyProjectTemp> queryResult = surveyProjectTempService.list(dataQuery_TmSjWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：根据类型和问卷id查询暂存问题-数据查询
    * @return
    */
    @Override
    public List<SurveyProjectTemp> dataQuery_fHTN(JSONObject paramsJsonContext,QueryTmpStgIssuesBasedOnTypeAndQuestionnaireIDBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long questionnaireID0 = bo.getQuestionnaireID();
        queryParams.put("surveyProjectTempQuestionnaireId", questionnaireID0);
        Integer questionType1Fixed2Open31 = bo.getQuestionType1Fixed2Open3();
        queryParams.put("surveyProjectTempQuestionType", questionType1Fixed2Open31);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_fHTNWhereBO dataQuery_fHTNWhereBO = BeanUtil.toBean(queryParams, DataQuery_fHTNWhereBO.class);
        List<SurveyProjectTemp> queryResult = surveyProjectTempService.list(dataQuery_fHTNWhereBO);
        return queryResult;
    }


    /**
    * 聚合查询：生成问卷-数据查询-问卷暂存问题
    * @return
    */
    @Override
    public List<SurveyProjectTemp> dataQuery_YsMU(JSONObject paramsJsonContext,GenQuestionnaireBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long questionnaireID0 = bo.getQuestionnaireID();
        queryParams.put("surveyProjectTempQuestionnaireId", questionnaireID0);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_YsMUWhereBO dataQuery_YsMUWhereBO = BeanUtil.toBean(queryParams, DataQuery_YsMUWhereBO.class);
        List<SurveyProjectTemp> queryResult = surveyProjectTempService.list(dataQuery_YsMUWhereBO);
        return queryResult;
    }


}