
package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import org.apache.commons.lang3.ObjectUtils;
import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.wlos.app.bl.*;
import com.wlos.app.dto.*;
import com.wlos.app.vo.*;
import com.wlos.app.bo.*;
import com.wlos.app.model.*;


import com.wlos.app.bo.where.*;


import com.wlos.app.da.service.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.*;
import java.time.*;

@Slf4j
@Service
public class SurveyExpertAggregateServiceImpl implements SurveyExpertAggregateService {

    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyExpertService surveyExpertService;


    /**
    * 聚合查询：计划绑定专家-数据查询-踏勘专家记录
    * @return
    */
    @Override
    public SurveyExpert dataQuery_KThG(JSONObject paramsJsonContext,PlanToBindExpertsBO bo) throws BusinessException {
        //调用数据查询
        log.info("==============执行查询");
        //查询条件参数
        Map queryParams= new HashMap();
        Long tskID0 = bo.getTskID();
        queryParams.put("surveyExpertTaskId", tskID0);
        Integer stage1 = bo.getStage();
        queryParams.put("surveyExpertSurveyStep", stage1);
        log.info("============dm params===:{}",JSON.toJSONString(queryParams));
        DataQuery_KThGWhereBO dataQuery_KThGWhereBO = BeanUtil.toBean(queryParams, DataQuery_KThGWhereBO.class);
        SurveyExpert queryResult = surveyExpertService.selectOne(dataQuery_KThGWhereBO);
        return queryResult;
    }


}