package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
/**
* 根据阶段查询问题数量
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryTheNumOfIssuesByStageService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据阶段查询问题数量";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    @Autowired
    private BaseFixedIssueAggregateService baseFixedIssueAggregateService;
    /**
    * 根据阶段查询问题数量接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryTheNumOfIssuesByStageDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryTheNumOfIssuesByStageBO bo = new QueryTheNumOfIssuesByStageBO();
        if (Objects.isNull(form)) {
            form = new QueryTheNumOfIssuesByStageDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //不是第1阶段
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"quantity",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("quantity",boMap.get("quantity"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        notPhase1(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 不是第1阶段
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void notPhase1(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "不是第1阶段";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(notPhase1ParamAssignment(paramsJsonContext, executeBO)){
            paramAssignment(paramsJsonContext, executeBO);
        }
        else {
            ifTheVenueCodeIs2Or4(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean notPhase1ParamAssignment(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            QueryTheNumOfIssuesByStageBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Integer stageV123 = bo.getStageV123();
            boolean matchState = (((DecimalUtil.ne(new BigDecimal(stageV123+""),new BigDecimal("1"+"")))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheNumOfIssuesByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Long constant0ddzkn0 = ElementConstants.constant0;
        bo.setQuantity(constant0ddzkn0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_dvJR==");
        //调用数据查询
        QueryTheNumOfIssuesByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        Page<BaseFixedIssue> vo = baseFixedIssueAggregateService.dataQuery_dvJR(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        paramAssignment_lUyi(paramsJsonContext, executeBO);
    }

    /**
    * 如果场地编码为2或4
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void ifTheVenueCodeIs2Or4(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "如果场地编码为2或4";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(ifTheVenueCodeIs2Or4ParamAssignment_cJhy(paramsJsonContext, executeBO)){
            paramAssignment_cJhy(paramsJsonContext, executeBO);
        }
        else {
            paramAssignment_Kfih(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean ifTheVenueCodeIs2Or4ParamAssignment_cJhy(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            QueryTheNumOfIssuesByStageBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            String siteType = bo.getSiteType();
            String siteTypegjfdn = bo.getSiteType();
            boolean matchState = (((siteType.equals("2"))))||(((siteTypegjfdn.equals("4"))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_cJhy(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheNumOfIssuesByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String nsztn0 = "1";
        bo.setAddrType(nsztn0);
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_Kfih(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheNumOfIssuesByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        String siteTypewuqcs0 = bo.getSiteType();
        bo.setAddrType(siteTypewuqcs0);
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_lUyi(JSONObject paramsJsonContext, QueryTheNumOfIssuesByStageBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheNumOfIssuesByStageBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Long totalilfvj0 = bo.getDataQuery().getTotal();
        bo.setQuantity(totalilfvj0);
        endEvent(paramsJsonContext, executeBO);
    }

}