package com.wlos.app.bl.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReUtil;
import org.springframework.beans.BeanUtils;
import com.wlos.app.dto.*;
import com.wlos.app.bl.*;
import com.wlos.app.model.*;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.utils.*;
import cn.hutool.extra.spring.SpringUtil;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jayway.jsonpath.JsonPath;
import com.alibaba.fastjson2.TypeReference;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.io.ByteArrayInputStream;
import java.util.*;
import org.apache.http.HttpStatus;
import java.time.*;
import java.util.stream.Collectors;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wlos.app.bo.*;
import com.wlos.app.vo.*;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.springframework.scheduling.annotation.Async;
/**
* 根据任务id查询踏勘计划次数
* @desc 
* @author
* @date 2024-08-30 17:02:53
*/
@Service
public class QueryTheNumOfExplorationPlansBasedOnTskIDService {

    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String processName = "根据任务id查询踏勘计划次数";
    @Autowired
    private ParamHandleService paramHandleService;
    @Autowired
    private SurveyPlanAggregateService surveyPlanAggregateService;
    @Autowired
    private GatewayMatchService gatewayMatchService;
    /**
    * 根据任务id查询踏勘计划次数接口执行主入口
    * @param form 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public JSONObject processMainExecute(QueryTheNumOfExplorationPlansBasedOnTskIDDTO form) throws BusinessException {
        //调用开始方法
        //初始化过程变量
        QueryTheNumOfExplorationPlansBasedOnTskIDBO bo = new QueryTheNumOfExplorationPlansBasedOnTskIDBO();
        if (Objects.isNull(form)) {
            form = new QueryTheNumOfExplorationPlansBasedOnTskIDDTO();
        }
        BeanUtils.copyProperties(form,bo);
        log.debug("流程名称：{},方法名称: processMainExecute,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJsonContext = new JSONObject();
        paramsJsonContext.put(Constants.DATA, new JSONObject(BeanUtil.beanToMap(form)));
        //立即触发
        //数据查询
        //运算-列表条数
        //分支
        //结束
        immediateStart(paramsJsonContext,bo);
        //获取返回的结果
        String[] returnDataKeyList = {"freq",};
        JSONObject vo = new JSONObject();
        Map<String, Object> boMap = BeanUtil.beanToMap(bo);
                vo.put("freq",boMap.get("freq"));
            log.debug("流程名称：{},方法名称: processMainExecute,输出参数: {}",processName,JSON.toJSONString(vo));
        return VoUtils.handleFileVo(vo,returnDataKeyList);
    }

    /**
    * 立即触发
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void immediateStart(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行方法=======");
        dataQuery(paramsJsonContext, executeBO);
    }

    /**
    * 结束
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void endEvent(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行结束方法=======");
    }

    /**
    * 数据查询
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void dataQuery(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行数据查询方法，taskName：数据查询==taskIdentifier：dataQuery==damMethod：dataQuery_bAiC==");
        //调用数据查询
        QueryTheNumOfExplorationPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 数据查询,输入参数: {}",processName,JSON.toJSONString(bo));
        List<SurveyPlan> vo = surveyPlanAggregateService.dataQuery_bAiC(paramsJsonContext,bo);
        bo.setDataQuery(vo);
        log.debug("流程名称：{},方法名称: 数据查询,输出参数: {}",processName,JSON.toJSONString(vo));
        calculationNumOfItemsInTheLst(paramsJsonContext, executeBO);
    }

    /**
    * 参数赋值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignment_gKNv(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheNumOfExplorationPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值,输入参数: {}",processName,JSON.toJSONString(bo));
        Integer codeBlktkspu0 = bo.getCodeBlk();
        bo.setFreq(codeBlktkspu0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 运算-列表条数
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void calculationNumOfItemsInTheLst(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行blockly方法=======");
        QueryTheNumOfExplorationPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 运算-列表条数,输入参数: {}",processName,JSON.toJSONString(bo));
        String script = "\n\n\nu_SearchData_U_c87e53eeb56c4c67931bce4c2caa420e_u.length;\n";
        List<BlocklyBindParamDto> bindparams = new ArrayList<>();

        String bindKey0 = "u_biz_flow_v2_local_variable_U_3c13ef7ad88e4aa7acf7de074e8ab295_u";
        String bindType0 = "";
        Object bindValue0 = null;
        BlocklyBindParamDto paramDto0 = BlocklyBindParamDto.builder()
                .bindValue(bindValue0)
                .bindKey(bindKey0)
                .bindType(bindType0)
                .build();
        bindparams.add(paramDto0);
        String bindKey1 = "u_SearchData_U_c87e53eeb56c4c67931bce4c2caa420e_u";
        String bindType1 = "List";
        List bindValue1 = bo.getDataQuery();
        BlocklyBindParamDto paramDto1 = BlocklyBindParamDto.builder()
                .bindValue(bindValue1)
                .bindKey(bindKey1)
                .bindType(bindType1)
                .build();
        bindparams.add(paramDto1);
        Object evalValue = BlocklyUtils.exe(script, bindparams);
        log.info("=====blockly js执行输出的结果，处理后的====" + JSON.toJSONString(evalValue));
        
        Integer vo = Double.valueOf(String.valueOf(evalValue)).intValue();
        bo.setCalculationNumOfItemsInTheLst(vo);
        log.debug("流程名称：{},方法名称: 运算-列表条数,输出参数: {}",processName,JSON.toJSONString(vo));
        branch(paramsJsonContext, executeBO);
    }

    /**
    * 分支
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void branch(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行分支方法=======");
        String taskName = "分支";
        String errorSuffix = "[" + processName + "-" + taskName + "]";
        if(branchCodeBlk(paramsJsonContext, executeBO)){
            codeBlk(paramsJsonContext, executeBO);
        }
        else {
            paramAssignmentInitialV(paramsJsonContext, executeBO);
        }
    }
    /**
    * 满足条件
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public boolean branchCodeBlk(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行顺序流分支判断方法=======");
        try {
            QueryTheNumOfExplorationPlansBasedOnTskIDBO bo = executeBO;
            log.debug("流程名称：{},方法名称: 满足条件,输入参数: {}",processName,JSON.toJSONString(bo));
            Integer calculationNumOfItemsInTheLst = bo.getCalculationNumOfItemsInTheLst();
            boolean matchState = (((DecimalUtil.gt(new BigDecimal(calculationNumOfItemsInTheLst+""),new BigDecimal("0"+"")))));
            log.info("=====gateway matchState===" + matchState);
            return matchState;
        } catch (BusinessException e) {
            log.error("处理失败",e);
            return false;
        } catch (Exception e) {
            log.error("处理失败",e);
            return false;
        }
    }

    /**
    * 参数赋值-初始值
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void paramAssignmentInitialV(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行变量赋值方法=======");
        QueryTheNumOfExplorationPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 参数赋值-初始值,输入参数: {}",processName,JSON.toJSONString(bo));
        Integer dbqpz0 = 1;
        bo.setFreq(dbqpz0);
        endEvent(paramsJsonContext, executeBO);
    }

    /**
    * 代码块
    * @desc 
    * @param paramsJsonContext 入参
    * @return 返回值
    * @throws BusinessException 异常
    */
    public void codeBlk(JSONObject paramsJsonContext, QueryTheNumOfExplorationPlansBasedOnTskIDBO executeBO) throws BusinessException {
        log.info("========执行代码块方法=======");
        QueryTheNumOfExplorationPlansBasedOnTskIDBO bo = executeBO;
        log.debug("流程名称：{},方法名称: 代码块,输入参数: {}",processName,JSON.toJSONString(bo));
        JSONObject paramsJson = new JSONObject();
        List dataQuery0 = bo.getDataQuery();
        paramsJson.put("planList", dataQuery0);
        Integer vo = codeBlkCodeBlock(paramsJson);
        bo.setCodeBlk(vo);
        paramAssignment_gKNv(paramsJsonContext, executeBO);
    }

    /**
     * 代码块执行代码块方法体
     * @param params
     * param planList 计划列表
     * @return 返回值
     */
    public Integer codeBlkCodeBlock(JSONObject params) throws BusinessException{
        //自定义代码块逻辑
        JSONArray planList = params.getJSONArray("planList");
return planList.getJSONObject(0).getInteger("time")+1;




    }

}